/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ogcapi;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Optional;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ogcapi.GeoJSONAPIWriter;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.springframework.web.context.request.RequestContextHolder;

class GeoJSONTemplateGetFeatureResponse
extends org.geoserver.featurestemplating.ows.wfs.GeoJSONTemplateGetFeatureResponse {
    public GeoJSONTemplateGetFeatureResponse(GeoServer gs, TemplateLoader configuration, TemplateIdentifier identifier) {
        super(gs, configuration, identifier);
    }

    protected GeoJSONWriter getOutputWriter(OutputStream output) throws IOException {
        return new GeoJSONAPIWriter(new JsonFactory().createGenerator(output, JsonEncoding.UTF8), this.identifier);
    }

    protected void writeAdditionalFieldsInternal(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature, BigInteger featureCount, ReferencedEnvelope bounds) throws IOException {
        boolean isGeoJson = this.identifier.equals((Object)TemplateIdentifier.GEOJSON);
        if (!isGeoJson) {
            super.writeAdditionalFieldsInternal(writer, featureCollection, getFeature, featureCount, bounds);
            return;
        }
        if (!EncodingHints.isSingleFeatureRequest()) {
            writer.writeNumberReturned();
            writer.writeTimeStamp();
        }
        String collId = getFeature.getParameters()[0].toString();
        String name = this.helper.getFeatureType(collId).prefixedName();
        ((GeoJSONAPIWriter)writer).writeLinks(featureCollection.getPrevious(), featureCollection.getNext(), name, this.getItemId(), this.getMimeType(null, null));
    }

    private String getItemId() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(att -> (String)att.getAttribute(FeatureService.ITEM_ID, 0)).orElse(null);
    }
}

