/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.featurestemplating.response.GeoJSONGetSimpleFeaturesResponseTest;
import org.junit.Assert;
import org.junit.Test;

public class GeoJSONGetSimpleFeaturesResponseAPITest
extends GeoJSONGetSimpleFeaturesResponseTest {
    @Test
    public void testGeoJSONResponseOGCAPI() throws Exception {
        this.setUpSimple("NamedPlacesGeoJSON.json");
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("cite:NamedPlaces").append("/items?f=application/json");
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)2L);
        for (int i = 0; i < features.size(); ++i) {
            this.checkFeature(features.getJSONObject(i));
        }
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONResponseOGCAPIWithFilter() throws Exception {
        this.setUpSimple("NamedPlacesGeoJSON.json");
        StringBuilder path = new StringBuilder("ogc/features/v1/collections/").append("cite:NamedPlaces").append("/items?f=application/json").append("&filter= features.id = '118'").append("&filter-lang=cql-text");
        JSONObject result = (JSONObject)this.getJson(path.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)1L);
        JSONObject feature = (JSONObject)features.get(0);
        Assert.assertEquals((Object)feature.getString("id"), (Object)"118");
        Assert.assertNotNull((String)feature.getString("name"), (Object)"Goose Island");
        JSONObject geometry = (JSONObject)feature.get("geometry");
        Assert.assertEquals((Object)geometry.getString("type"), (Object)"MultiPolygon");
        this.checkAdditionalInfo(result);
    }
}

