/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.featurestemplating.response.JSONLDGetSimpleFeaturesResponseTest;
import org.junit.Assert;
import org.junit.Test;

public class JSONLDGetSimpleFeaturesResponseAPITest
extends JSONLDGetSimpleFeaturesResponseTest {
    @Test
    public void testJsonLdResponseOGCAPI() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("cite:NamedPlaces").append("/items?f=application%2Fld%2Bjson");
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)2L);
        this.checkFeature((JSONObject)features.get(0));
    }

    @Test
    public void testJsonLdResponseOGCAPIWithFilter() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder path = new StringBuilder("ogc/features/v1/collections/").append("cite:NamedPlaces").append("/items?f=application%2Fld%2Bjson").append("&filter= features.id = '118'").append("&filter-lang=cql-text");
        JSONObject result = (JSONObject)this.getJsonLd(path.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)1L);
        JSONObject feature = (JSONObject)features.get(0);
        Assert.assertEquals((Object)feature.getString("id"), (Object)"118");
        Assert.assertNotNull((String)feature.getString("name"), (Object)"Goose Island");
        JSONObject geometry = (JSONObject)feature.get("geometry");
        Assert.assertEquals((Object)geometry.getString("@type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geometry.getString("wkt"));
    }

    @Test
    public void testJsonLdResponseOGCAPISingleFeature() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder path = new StringBuilder("ogc/features/v1/collections/").append("cite:NamedPlaces").append("/items/NamedPlaces.1107531895891?f=application%2Fld%2Bjson");
        JSONObject result = (JSONObject)this.getJsonLd(path.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((Object)"118", (Object)result.getString("id"));
        Assert.assertEquals((Object)"Goose Island", (Object)result.getString("name"));
        Assert.assertTrue((boolean)result.has("@type"));
        Assert.assertTrue((boolean)result.has("geometry"));
    }
}

