/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.FeatureChainingMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class SimplifiedPropertyReferenceTest
extends TemplateComplexTestSupport {
    protected static final String SIMPLIFIED_GML_TEMPLATE = "SimplifiedPropertyNamesGML32";
    protected static final String SIMPLIFIED_GML_PARAM = "&SimplifiedPropertyNamesGML32=true";
    protected static final String SIMPLIFIED_JSONLD_TEMPLATE = "SimplifiedPropertyNamesJSONLD";
    protected static final String SIMPLIFIED_JSONLD_PARAM = "&SimplifiedPropertyNamesJSONLD=true";
    protected static final String SIMPLIFIED_FLAT_TEMPLATE = "SimplifiedPropertyNamesFlat";
    protected static final String SIMPLIFIED_FLAT_PARAM = "&SimplifiedPropertyNamesFlat=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String simplifiedGML = "SimplifiedPropertyNames.xml";
        String simplifiedJSONLD = "SimplifiedPropertyNames.json";
        String simplifiedFlat = "FlatSimplifiedPropertyNames.json";
        this.setUpTemplate("requestParam('SimplifiedPropertyNamesGML32')='true'", SupportedFormat.GML, simplifiedGML, SIMPLIFIED_GML_TEMPLATE, ".xml", "gsml", mappedFeature);
        this.setUpTemplate("requestParam('SimplifiedPropertyNamesJSONLD')='true'", SupportedFormat.JSONLD, simplifiedJSONLD, SIMPLIFIED_JSONLD_TEMPLATE, ".json", "gsml", mappedFeature);
        this.setUpTemplate("requestParam('SimplifiedPropertyNamesFlat')='true'", SupportedFormat.GEOJSON, simplifiedFlat, SIMPLIFIED_FLAT_TEMPLATE, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testGML() throws IOException {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgml%2Bxml%3Bversion%3D3.2&&SimplifiedPropertyNamesGML32=true");
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathCount(5, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:lithology", doc);
    }

    @Test
    public void testJsonLd() throws Exception {
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fld%2Bjson&&SimplifiedPropertyNamesJSONLD=true";
        JSONObject result = (JSONObject)this.getJsonLd(path);
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertEquals((Object)"mf1", (Object)feature.getString("@id"));
        Assert.assertEquals((Object)"GUNTHORPE FORMATION", (Object)feature.getString("name"));
        String geometry = feature.getJSONObject("geometry").getString("wkt");
        Assert.assertNotNull((Object)geometry);
        JSONObject geologicUnit = feature.getJSONObject("gsml:GeologicUnit");
        Assert.assertEquals((Object)"Olivine basalt, tuff, microgabbro, minor sedimentary rocks", (Object)geologicUnit.getString("description"));
        JSONObject composition = geologicUnit.getJSONArray("gsml:composition").getJSONObject(0);
        JSONObject role = composition.getJSONObject("gsml:role");
        Assert.assertEquals((Object)"staticValue", (Object)role.getString("staticValue"));
        JSONObject lithology = composition.getJSONArray("lithology").getJSONObject(0);
        String value = lithology.getJSONObject("name").getString("value");
        Assert.assertEquals((Object)"name_cc_5", (Object)value);
    }

    @Test
    public void testFlatGeoJSON() throws Exception {
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgeo%2Bjson&&SimplifiedPropertyNamesFlat=true";
        JSONObject result = (JSONObject)this.getJson(path);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertNotNull((Object)feature.getJSONObject("geometry"));
        Assert.assertEquals((Object)"mf1", (Object)feature.getString("@id"));
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertEquals((Object)"FeatureName: GUNTHORPE FORMATION", (Object)properties.getString("name"));
        Assert.assertEquals((Object)"Olivine basalt, tuff, microgabbro, minor sedimentary rocks", (Object)properties.getString("gsml:GeologicUnit_description"));
        Assert.assertEquals((Object)"fictitious component", (Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_gsml:role_value"));
        Assert.assertEquals((Object)"name_cc_5", (Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_name"));
    }

    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData(){

            public Map<String, String> getNamespaces() {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                namespaces.put("gml", "http://www.opengis.net/gml/3.2");
                namespaces.put("wfs", "http://www.opengis.net/wfs/2.0");
                namespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
                namespaces.put("xlink", "http://www.w3.org/1999/xlink");
                return namespaces;
            }
        };
    }
}

