/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ogcapi;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.features.CollectionDocument;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.http.MediaType;

public class GeoJSONAPIWriter
extends GeoJSONWriter {
    public GeoJSONAPIWriter(JsonGenerator generator, TemplateIdentifier identifier) {
        super(generator, identifier);
    }

    public void startTemplateOutput(EncodingHints encodingHints) throws IOException {
        boolean isGeoJSON = this.identifier.equals((Object)TemplateIdentifier.GEOJSON);
        if (EncodingHints.isSingleFeatureRequest() && isGeoJSON) {
            this.startObject(null, encodingHints);
        } else {
            super.startTemplateOutput(encodingHints);
        }
    }

    public void writeLinks(String previous, String next, String prefixedName, String featureId, String mimeType) throws IOException {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        this.startArray("links", null);
        if (previous != null) {
            this.writeLink(previous, "prev", mimeType, "Previous page", null);
        }
        if (next != null) {
            this.writeLink(next, "next", mimeType, "Next page", null);
        }
        String basePath = "ogc/features/v1/collections/" + ResponseUtils.urlEncode((String)prefixedName, (char[])new char[0]);
        Collection formats = requestInfo.getProducibleMediaTypes(FeaturesResponse.class, true);
        for (MediaType format : formats) {
            String path = basePath + "/items";
            if (featureId != null) {
                path = path + "/" + ResponseUtils.urlEncode((String)featureId, (char[])new char[0]);
            }
            String href = ResponseUtils.buildURL((String)requestInfo.getBaseURL(), (String)path, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "alternate";
            Object linkTitle = "This document as " + format;
            if (format.toString().equals(mimeType)) {
                linkType = "self";
                linkTitle = "This document";
            }
            this.writeLink(href, linkType, format.toString(), (String)linkTitle, null);
        }
        for (MediaType format : requestInfo.getProducibleMediaTypes(CollectionDocument.class, true)) {
            String href = ResponseUtils.buildURL((String)requestInfo.getBaseURL(), (String)basePath, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "collection";
            String linkTitle = "The collection description as " + format;
            this.writeLink(href, linkType, format.toString(), linkTitle, null);
        }
        this.endArray(null, null);
    }

    public void startObject(String name, EncodingHints encodingHints) throws IOException {
        if (!this.skipObjectWriting(encodingHints)) {
            super.startObject(name, encodingHints);
        }
    }

    public void endObject(String name, EncodingHints encodingHints) throws IOException {
        if (!this.skipObjectWriting(encodingHints)) {
            super.endObject(name, encodingHints);
        }
    }
}

