/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ogcapi;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geoserver.featurestemplating.ogcapi.GeoJSONTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.ows.TemplateCallback;
import org.geoserver.featurestemplating.ows.wfs.GMLTemplateResponse;
import org.geoserver.featurestemplating.ows.wfs.HTMLTemplateResponse;
import org.geoserver.featurestemplating.request.TemplatePathVisitor;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.kvp.FormatOptionsKvpParser;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.XCQL;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.logging.Logging;

public class TemplateCallBackOGC
extends AbstractDispatcherCallback {
    static final FormatOptionsKvpParser PARSER = new FormatOptionsKvpParser("env");
    private static final Logger LOGGER = Logging.getLogger(TemplateCallback.class);
    private Catalog catalog;
    private TemplateLoader configuration;
    private GeoServer gs;
    private final String FEATURES_SERVICE;
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    public TemplateCallBackOGC(GeoServer gs, TemplateLoader configuration) {
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
        this.gs = gs;
        APIService annotation = FeatureService.class.getAnnotation(APIService.class);
        this.FEATURES_SERVICE = annotation.service();
    }

    public Operation operationDispatched(Request request, Operation operation) {
        boolean isOpWithParams;
        TemplateIdentifier identifier = this.getTemplateIdentifier(request);
        boolean bl = isOpWithParams = operation != null && operation.getParameters().length > 0;
        if (identifier != null && isOpWithParams) {
            String ftName;
            String outputFormat = identifier.getOutputFormat();
            Object param = operation.getParameters()[0];
            String string = ftName = param != null ? param.toString() : null;
            if ("FEATURES".equalsIgnoreCase(request.getService()) && outputFormat != null) {
                try {
                    FeatureTypeInfo typeInfo = this.catalog.getFeatureTypeByName(ftName);
                    if (typeInfo == null) {
                        return operation;
                    }
                    RootBuilder root = this.configuration.getTemplate(typeInfo, outputFormat);
                    String filterLang = (String)request.getKvp().get("FILTER-LANG");
                    String filter = (String)request.getKvp().get("FILTER");
                    if (filter != null && (filterLang == null || filterLang.equalsIgnoreCase("CQL-TEXT"))) {
                        this.replaceTemplatePathWithFilter(filter, root, typeInfo, operation);
                    }
                    String envParam = request.getRawKvp().get("ENV") != null ? request.getRawKvp().get("ENV").toString() : null;
                    this.setEnvParameter(envParam);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.operationDispatched(request, operation);
    }

    private void setEnvParameter(String env) {
        if (env != null) {
            try {
                Map localEnvVars = (Map)PARSER.parse(env);
                EnvFunction.setLocalValues((Map)localEnvVars);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid syntax for environment variables", e);
            }
        }
    }

    private FeatureTypeInfo getFeatureType(String collectionId) {
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName(collectionId);
        if (featureType == null) {
            throw new ServiceException("Unknown collection " + collectionId, "InvalidParameterValue", "collectionId");
        }
        return featureType;
    }

    private TemplateIdentifier getTemplateIdentifier(Request request) {
        String accept = request.getHttpRequest().getHeader("Accept");
        String format = request.getKvp() != null ? (String)request.getKvp().get("f") : null;
        TemplateIdentifier identifier = null;
        if (format != null) {
            identifier = TemplateIdentifier.fromOutputFormat((String)format);
        } else if (accept != null) {
            identifier = this.getTemplateIdentifierFromAcceptString(accept);
        }
        return identifier;
    }

    private TemplateIdentifier getTemplateIdentifierFromAcceptString(String accept) {
        String[] split;
        if (StringUtils.isBlank((CharSequence)accept)) {
            return null;
        }
        for (String s : split = accept.split(",")) {
            TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat((String)s.trim());
            if (identifier == null) continue;
            return identifier;
        }
        return null;
    }

    private void replaceTemplatePathWithFilter(String strFilter, RootBuilder root, FeatureTypeInfo typeInfo, Operation operation) throws Exception {
        if (root != null) {
            this.replaceFilter(strFilter, root, typeInfo, operation);
        }
    }

    private void replaceFilter(String strFilter, RootBuilder root, FeatureTypeInfo typeInfo, Operation operation) throws IOException, CQLException {
        Filter filter = XCQL.toFilter((String)strFilter);
        this.replaceFilter(filter, root, typeInfo, operation);
    }

    private void replaceFilter(Filter filter, RootBuilder root, FeatureTypeInfo typeInfo, Operation operation) throws IOException, CQLException {
        TemplatePathVisitor visitor = new TemplatePathVisitor(typeInfo.getFeatureType());
        Filter f = (Filter)filter.accept((FilterVisitor)visitor, (Object)root);
        if (filter.equals(f)) {
            LOGGER.warning("Failed to resolve filter " + filter + " against the template. If the property name was intended to be a template path, check that the path specified in the cql filter is correct.");
        }
        ArrayList<Filter> templateFilters = new ArrayList<Filter>();
        templateFilters.addAll(visitor.getFilters());
        if (templateFilters != null && templateFilters.size() > 0) {
            templateFilters.add(f);
            f = FF.and(templateFilters);
        }
        String newFilter = this.fixPropertyNames(ECQL.toCQL((Filter)f));
        newFilter = TemplateCQLManager.quoteXpathAttribute((String)newFilter);
        Object[] operationParameters = operation.getParameters();
        operationParameters[6] = newFilter;
    }

    private String fixPropertyNames(String cqlFilter) {
        HashMap<CallSite, String> replacements = new HashMap<CallSite, String>();
        Pattern p = Pattern.compile("\"([^\"]*)\"");
        Matcher m = p.matcher(cqlFilter);
        while (m.find()) {
            String matched = m.group(1);
            String quoted = "\"" + matched + "\"";
            replacements.put((CallSite)((Object)quoted), matched.replaceAll("/", "."));
        }
        for (String toReplace : replacements.keySet()) {
            String replacement = (String)replacements.get(toReplace);
            cqlFilter = cqlFilter.replace(toReplace, replacement);
        }
        return cqlFilter;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        FeatureTypeInfo typeInfo;
        TemplateIdentifier identifier = this.getTemplateIdentifier(request);
        if (identifier != null && !identifier.equals((Object)TemplateIdentifier.JSONLD) && request.getService().equals(this.FEATURES_SERVICE) && result instanceof FeaturesResponse && (typeInfo = this.getFeatureType((String)operation.getParameters()[0])) != null) {
            try {
                Response templateResp;
                RootBuilder root = this.configuration.getTemplate(typeInfo, identifier.getOutputFormat());
                if (root != null && (templateResp = this.getTemplateResponse(operation, result, identifier)) != null) {
                    response = templateResp;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    private Response getTemplateResponse(final Operation operation, final Object result, TemplateIdentifier identifier) {
        Object templatingResp = null;
        switch (identifier) {
            case JSON: 
            case GEOJSON: {
                templatingResp = new GeoJSONTemplateGetFeatureResponse(this.gs, this.configuration, identifier){

                    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
                        FeaturesResponse fr = (FeaturesResponse)result;
                        super.write(fr.getResponse(), output, operation);
                    }
                };
                break;
            }
            case GML32: {
                templatingResp = new GMLTemplateResponse(this.gs, this.configuration, identifier){

                    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
                        FeaturesResponse fr = (FeaturesResponse)result;
                        super.write(fr.getResponse(), output, operation);
                    }
                };
                break;
            }
            case HTML: {
                templatingResp = new HTMLTemplateResponse(this.gs, this.configuration){

                    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
                        FeaturesResponse fr = (FeaturesResponse)result;
                        super.write(fr.getResponse(), output, operation);
                    }
                };
            }
        }
        return templatingResp;
    }
}

