/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.FeatureChainingMockData;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ComplexGetFeatureInfoTest
extends TemplateComplexTestSupport {
    private static final String MF_GML_FEATUREINFO = "GMLFeatureInfoMappedFeature";
    private static final String MF_GML_PARAM = "&GMLFeatureInfoMappedFeature=true";
    private static final String MF_GEOJSON_FEATUREINFO = "GeoJSONFeatureInfoMappedFeature";
    private static final String MF_GEOJSON_PARAM = "&GeoJSONFeatureInfoMappedFeature=true";
    private static final String MF_JSONLD_FEATUREINFO = "JSONLDFeatureInfoMappedFeature";
    private static final String MF_JSONLD_PARAM = "&JSONLDFeatureInfoMappedFeature=true";
    private static final String MF_HTML_FEATUREINFO = "HTMLFeatureInfoMappedFeature";
    private static final String MF_HTML_PARAM = "&HTMLFeatureInfoMappedFeature=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeatureGML = "ManagedMappedFeatureGML32.xml";
        this.setUpTemplate("requestParam('GMLFeatureInfoMappedFeature')='true'", SupportedFormat.GML, templateMappedFeatureGML, MF_GML_FEATUREINFO, ".xml", "gsml", mappedFeature);
        String templateMappedFeatureGeoJSON = "ManagedMappedFeatureGeoJSON.json";
        this.setUpTemplate("requestParam('GeoJSONFeatureInfoMappedFeature')='true'", SupportedFormat.GEOJSON, templateMappedFeatureGeoJSON, MF_GEOJSON_FEATUREINFO, ".json", "gsml", mappedFeature);
        String templateMappedFeatureJSONLD = "ManagedMappedFeatureJSONLD.json";
        this.setUpTemplate("requestParam('JSONLDFeatureInfoMappedFeature')='true'", SupportedFormat.JSONLD, templateMappedFeatureJSONLD, MF_JSONLD_FEATUREINFO, ".json", "gsml", mappedFeature);
        String templateMappedFeatureHTML = "HTMLMappedFeature.xhtml";
        this.setUpTemplate("requestParam('HTMLFeatureInfoMappedFeature')='true'", SupportedFormat.HTML, templateMappedFeatureHTML, MF_HTML_FEATUREINFO, ".xhtml", "gsml", mappedFeature);
    }

    @Test
    public void testHTML() throws Exception {
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=text/html&HTMLFeatureInfoMappedFeature=true";
        Document doc = this.getAsJSoup(request);
        Assert.assertEquals((long)1L, (long)doc.select("script").size());
        Assert.assertEquals((long)1L, (long)doc.select("style").size());
        Assert.assertEquals((long)1L, (long)doc.select("span.caret:contains(MappedFeature)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf2)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(MERCIA MUDSTONE GROUP)").size());
        Assert.assertEquals((long)1L, (long)doc.select("span:contains(Shape)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li span:contains(Specifications)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li span:contains(Geologic Unit)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li span:contains(Purpose)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(instance)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(Yaugher Volcanic Group 1)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(Yaugher Volcanic Group 2)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(-Py)").size());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li span:contains(Composition Parts)").size());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li ul li span:contains(Part)").size());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li ul li span:contains(Role)").size());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li ul li ul li ul li:contains(interbedded component)").size());
    }

    @Test
    public void testJSONLD() throws Exception {
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=application%2Fld%2Bjson&JSONLDFeatureInfoMappedFeature=true";
        JSONObject result = (JSONObject)this.getJsonLd(request);
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = (JSONObject)features.get(0);
        this.checkMappedFeatureJSON(feature);
        Assert.assertEquals((Object)feature.get("nullObject").toString(), (Object)"null");
        Assert.assertEquals((Object)feature.get("nullText").toString(), (Object)"null");
        Assert.assertEquals(JSONNull.class, feature.get("nullObject").getClass());
        Assert.assertEquals(JSONNull.class, feature.get("nullText").getClass());
    }

    @Test
    public void testGeoJSON() throws Exception {
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=application/json&GeoJSONFeatureInfoMappedFeature=true";
        JSONObject result = (JSONObject)this.getJson(request);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = (JSONObject)features.get(0);
        this.checkMappedFeatureJSON(feature);
        Assert.assertEquals((Object)feature.get("nullObject").toString(), (Object)"null");
        Assert.assertEquals((Object)feature.get("nullText").toString(), (Object)"null");
    }

    @Test
    public void testGML() {
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=text/xml&GMLFeatureInfoMappedFeature=true";
        org.w3c.dom.Document doc = this.getAsDOM(request);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gml:description/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent/@xlink:title", doc);
        this.assertXpathCount(1, "//gsml:lithology", doc);
        this.assertXpathCount(1, "//gml:emptyText", doc);
        this.assertXpathEvaluatesTo("", "//gml:emptyText", doc);
    }

    protected AbstractAppSchemaMockData createTestData() {
        FeatureChainingMockData mockData = new FeatureChainingMockData(){

            public Map<String, String> getNamespaces() {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                namespaces.put("gml", "http://www.opengis.net/gml/3.2");
                namespaces.put("wfs", "http://www.opengis.net/wfs/2.0");
                namespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
                namespaces.put("xlink", "http://www.w3.org/1999/xlink");
                return namespaces;
            }
        };
        mockData.addStyle("Default", "styles/Default.sld");
        return mockData;
    }
}

