/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.FeatureChainingMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ManagedComplexFeaturesResponseTest
extends TemplateComplexTestSupport {
    private static final String MF_GML_MANAGED = "GMLManagedMappedFeature";
    private static final String MF_GML_PARAM = "&GMLManagedMappedFeature=true";
    private static final String MF_GEOJSON_MANAGED = "GeoJSONManagedMappedFeature";
    private static final String MF_GEOJSON_PARAM = "&GeoJSONManagedMappedFeature=true";
    private static final String MF_JSONLD_MANAGED = "JSONLDManagedMappedFeature";
    private static final String MF_JSONLD_PARAM = "&JSONLDManagedMappedFeature=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeatureGML = "ManagedMappedFeatureGML32.xml";
        this.setUpTemplate("requestParam('GMLManagedMappedFeature')='true'", SupportedFormat.GML, templateMappedFeatureGML, MF_GML_MANAGED, ".xml", "gsml", mappedFeature);
        String templateMappedFeatureGeoJSON = "ManagedMappedFeatureGeoJSON.json";
        this.setUpTemplate("requestParam('GeoJSONManagedMappedFeature')='true'", SupportedFormat.GEOJSON, templateMappedFeatureGeoJSON, MF_GEOJSON_MANAGED, ".json", "gsml", mappedFeature);
        String templateMappedFeatureJSONLD = "ManagedMappedFeatureJSONLD.json";
        this.setUpTemplate("requestParam('JSONLDManagedMappedFeature')='true'", SupportedFormat.JSONLD, templateMappedFeatureJSONLD, MF_JSONLD_PARAM, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testGMLResponse() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application%2Fgml%2Bxml%3B%20version%3D3.2");
        sb.append(MF_GML_PARAM);
        Document doc = this.getAsDOM(sb.toString());
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathCount(5, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gml:description/@xlink:href", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent/@xlink:title", doc);
        this.assertXpathCount(2, "//gsml:lithology", doc);
    }

    @Test
    public void testJsonLdResponse() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application%2Fld%2Bjson");
        sb.append(MF_JSONLD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureJSON(feature);
        }
    }

    @Test
    public void testGeoJSONResponse() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application/json");
        sb.append(MF_GEOJSON_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureJSON(feature);
        }
    }

    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData(){

            public Map<String, String> getNamespaces() {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                namespaces.put("gml", "http://www.opengis.net/gml/3.2");
                namespaces.put("wfs", "http://www.opengis.net/wfs/2.0");
                namespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
                namespaces.put("xlink", "http://www.w3.org/1999/xlink");
                return namespaces;
            }
        };
    }
}

