/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows;

import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.ows.wfs.GMLTemplateResponse;
import org.geoserver.featurestemplating.ows.wfs.GeoJSONTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.ows.wfs.HTMLTemplateResponse;
import org.geoserver.featurestemplating.ows.wfs.JSONLDGetFeatureResponse;
import org.geoserver.featurestemplating.ows.wms.GMLTemplateFeatureInfo;
import org.geoserver.featurestemplating.ows.wms.GeoJSONTemplateFeatureInfo;
import org.geoserver.featurestemplating.ows.wms.HTMLTemplateFeatureInfo;
import org.geoserver.featurestemplating.ows.wms.JSONLDTemplateFeatureInfo;
import org.geoserver.featurestemplating.ows.wms.TemplateFeatureInfoOutputFormat;
import org.geoserver.featurestemplating.ows.wms.TemplateGetFeatureInfoResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoResponse;

public class OWSResponseFactory {
    private GeoServer gs;
    private TemplateLoader loader;

    public static OWSResponseFactory getInstance() {
        return (OWSResponseFactory)GeoServerExtensions.bean(OWSResponseFactory.class);
    }

    public OWSResponseFactory(GeoServer gs, TemplateLoader templateLoader) {
        this.gs = gs;
        this.loader = templateLoader;
    }

    public BaseTemplateGetFeatureResponse getFeatureResponse(TemplateIdentifier identifier) {
        BaseTemplateGetFeatureResponse resp = null;
        if (identifier != null) {
            switch (identifier) {
                case JSON: 
                case GEOJSON: {
                    resp = new GeoJSONTemplateGetFeatureResponse(this.gs, this.loader, identifier);
                    break;
                }
                case GML32: 
                case GML31: 
                case GML2: {
                    resp = new GMLTemplateResponse(this.gs, this.loader, identifier);
                    break;
                }
                case HTML: {
                    resp = new HTMLTemplateResponse(this.gs, this.loader);
                    break;
                }
                case JSONLD: {
                    resp = new JSONLDGetFeatureResponse(this.gs, this.loader);
                }
            }
        }
        return resp;
    }

    public GetFeatureInfoResponse featureInfoResponse(TemplateIdentifier identifier, String origFormat) {
        if (identifier == null) {
            return null;
        }
        TemplateFeatureInfoOutputFormat resp = null;
        if (identifier.equals((Object)TemplateIdentifier.HTML)) {
            resp = new HTMLTemplateFeatureInfo(origFormat);
        } else if (identifier.equals((Object)TemplateIdentifier.GEOJSON) || identifier.equals((Object)TemplateIdentifier.JSON)) {
            resp = new GeoJSONTemplateFeatureInfo(identifier, origFormat);
        } else if (this.isGML(identifier)) {
            resp = new GMLTemplateFeatureInfo(identifier, origFormat);
        } else if (identifier.equals((Object)TemplateIdentifier.JSONLD)) {
            resp = new JSONLDTemplateFeatureInfo();
        }
        WMS wms = (WMS)GeoServerExtensions.bean(WMS.class);
        TemplateGetFeatureInfoResponse response = new TemplateGetFeatureInfoResponse(wms, resp);
        return response;
    }

    private boolean isGML(TemplateIdentifier identifier) {
        return identifier.equals((Object)TemplateIdentifier.GML2) || identifier.equals((Object)TemplateIdentifier.GML31) || identifier.equals((Object)TemplateIdentifier.GML32);
    }
}

