/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.opengis.wfs.GetFeatureType;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.writers.GMLTemplateWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.featurestemplating.writers.XMLTemplateWriter;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class GMLTemplateResponse
extends BaseTemplateGetFeatureResponse {
    public GMLTemplateResponse(GeoServer gs, TemplateLoader configuration, TemplateIdentifier identifier) {
        super(gs, configuration, identifier);
    }

    @Override
    protected void beforeFeatureIteration(TemplateOutputWriter writer, RootBuilder root, FeatureTypeInfo typeInfo) {
        String typeName = typeInfo.getName();
        ((GMLTemplateWriter)writer).setTypeName(typeName);
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
        String outputFormat = this.getMimeType(null, getFeature);
        try (GMLTemplateWriter writer = this.getOutputWriter(output, outputFormat);){
            this.setNamespacesAndSchemaLocations(featureCollection, (XMLTemplateWriter)writer, outputFormat);
            writer.startTemplateOutput(null);
            this.writeAdditionalFields((TemplateOutputWriter)writer, featureCollection, getFeature);
            this.iterateFeatureCollection((TemplateOutputWriter)writer, featureCollection, getFeature);
            writer.endTemplateOutput(null);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    protected void writeAdditionalFieldsInternal(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature, BigInteger featureCount, ReferencedEnvelope bounds) throws IOException {
        try {
            writer.writeCollectionCounts(featureCount);
            writer.writeNumberReturned();
            writer.writeTimeStamp();
            if (bounds != null) {
                writer.writeCollectionBounds(bounds);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected GMLTemplateWriter getOutputWriter(OutputStream output, String outputFormat) throws IOException {
        return (GMLTemplateWriter)this.helper.getOutputWriter(output, outputFormat);
    }

    private void setNamespacesAndSchemaLocations(FeatureCollectionResponse response, XMLTemplateWriter writer, String outputFormat) throws ExecutionException {
        List collectionList = response.getFeature();
        for (FeatureCollection collection : collectionList) {
            String schemaLocation;
            FeatureTypeInfo fti = this.helper.getFeatureTypeInfo(collection);
            RootBuilder root = this.configuration.getTemplate(fti, outputFormat);
            Map namespaces = (Map)root.getVendorOptions().get("NAMESPACES", Map.class, new HashMap());
            Map namespaces2 = (Map)root.getEncodingHints().get((Object)"NAMESPACES");
            if (namespaces2 != null) {
                namespaces.putAll(namespaces2);
            }
            if ((schemaLocation = (String)root.getVendorOptions().get((Object)"SCHEMA_LOCATION")) == null) {
                schemaLocation = (String)root.getEncodingHints().get((Object)"SCHEMA_LOCATION");
            }
            if (namespaces != null) {
                writer.addNamespaces(namespaces);
            }
            if (schemaLocation == null) continue;
            writer.addSchemaLocations(schemaLocation);
        }
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Object param;
        Object[] parameters;
        if (operation != null && (parameters = operation.getParameters()).length > 0 && (param = parameters[0]) instanceof GetFeatureType) {
            return ((GetFeatureType)param).getOutputFormat();
        }
        return TemplateIdentifier.GML32.getOutputFormat();
    }

    @Override
    protected void beforeEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
        super.beforeEvaluation(writer, root, feature);
        ((GMLTemplateWriter)writer).startFeatureMember();
    }

    @Override
    protected void afterEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
        super.afterEvaluation(writer, root, feature);
        ((GMLTemplateWriter)writer).endFeatureMember();
    }
}

