/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.VendorOptions;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.featurestemplating.writers.XHTMLTemplateWriter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class HTMLTemplateResponse
extends BaseTemplateGetFeatureResponse {
    private static final String ELEMENT_NAME = "HTML";

    public HTMLTemplateResponse(GeoServer gs, TemplateLoader configuration) {
        super(gs, configuration, TemplateIdentifier.HTML);
    }

    @Override
    protected void beforeFeatureIteration(TemplateOutputWriter writer, RootBuilder root, FeatureTypeInfo typeInfo) {
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
        String outputFormat = this.getMimeType(null, getFeature);
        try (XHTMLTemplateWriter writer = this.getOutputWriter(output, outputFormat);){
            writer.startTemplateOutput(this.mapVendorOptionsToHints(featureCollection, outputFormat));
            this.iterateFeatureCollection((TemplateOutputWriter)writer, featureCollection, getFeature);
            writer.endTemplateOutput(null);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    protected void writeAdditionalFieldsInternal(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature, BigInteger featureCount, ReferencedEnvelope bounds) throws IOException {
    }

    protected XHTMLTemplateWriter getOutputWriter(OutputStream output, String outputFormat) throws IOException {
        return (XHTMLTemplateWriter)this.helper.getOutputWriter(output, outputFormat);
    }

    private EncodingHints mapVendorOptionsToHints(FeatureCollectionResponse response, String outputFormat) throws ExecutionException {
        List collectionList = response.getFeature();
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> styles = new ArrayList<String>();
        ArrayList<FeatureCollection> jsonLdCollections = new ArrayList<FeatureCollection>();
        EncodingHints encodingHints = new EncodingHints();
        for (FeatureCollection collection : collectionList) {
            FeatureTypeInfo fti = this.helper.getFeatureTypeInfo(collection);
            RootBuilder root = this.configuration.getTemplate(fti, outputFormat);
            String script = (String)root.getVendorOptions().get("script", String.class, (Object)"");
            String style = (String)root.getVendorOptions().get("style", String.class, (Object)"");
            if (!script.isEmpty()) {
                scripts.add(script);
            }
            if (!style.isEmpty()) {
                styles.add(style);
            }
            VendorOptions options = root.getVendorOptions();
            this.addLinks(options, encodingHints);
            this.addToJsonLdScriptNameList(jsonLdCollections, options, collection);
        }
        if (!scripts.isEmpty()) {
            encodingHints.put((Object)"script", scripts);
        }
        if (!styles.isEmpty()) {
            encodingHints.put((Object)"style", styles);
        }
        if (!jsonLdCollections.isEmpty()) {
            encodingHints.put((Object)"JSON_LD_SCRIPT", jsonLdCollections);
        }
        return encodingHints;
    }

    private void addToJsonLdScriptNameList(List<FeatureCollection> jsonLdScriptNames, VendorOptions options, FeatureCollection collection) {
        boolean jsonLdScript = (Boolean)options.get("JSON_LD_SCRIPT", Boolean.class, (Object)false);
        if (jsonLdScript) {
            jsonLdScriptNames.add(collection);
        }
    }

    private void addLinks(VendorOptions options, EncodingHints hints) {
        if (options.keySet().stream().anyMatch(k -> k.startsWith("link"))) {
            for (String key : options.keySet()) {
                if (key == null || !key.startsWith("link")) continue;
                hints.put((Object)key, options.get((Object)key));
            }
        }
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return TemplateIdentifier.HTML.getOutputFormat();
    }

    @Override
    protected void beforeEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
        super.beforeEvaluation(writer, root, feature);
    }

    @Override
    protected void afterEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
        super.afterEvaluation(writer, root, feature);
    }

    protected boolean canHandleInternal(Operation operation) {
        boolean result = super.canHandleInternal(operation);
        if (result) {
            boolean hasParam;
            String outputFormat = this.identifier.getOutputFormat();
            boolean bl = hasParam = operation != null && operation.getParameters() != null && operation.getParameters().length > 0;
            if (hasParam) {
                String param = operation.getParameters()[0].toString();
                Request request = (Request)Dispatcher.REQUEST.get();
                if (this.isFeaturesRequest(request, param, outputFormat)) {
                    Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
                    FeatureTypeInfo fti = catalog.getFeatureTypeByName(param);
                    result = this.hasTemplate(fti);
                }
            }
        }
        return result;
    }

    private boolean hasTemplate(FeatureTypeInfo fti) {
        boolean result = true;
        try {
            RootBuilder template = this.configuration.getTemplate(fti, TemplateIdentifier.HTML.getOutputFormat());
            if (template == null) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private boolean isFeaturesRequest(Request request, String ftName, String outputFormat) {
        return request != null && ftName != null && "FEATURES".equalsIgnoreCase(request.getService()) && outputFormat != null;
    }

    public String getCapabilitiesElementName() {
        return ELEMENT_NAME;
    }
}

