/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.validation.JSONLDContextValidation;
import org.geoserver.featurestemplating.writers.JSONLDOutputHelper;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.feature.Feature;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class JSONLDGetFeatureResponse
extends BaseTemplateGetFeatureResponse {
    private static final String ELEMENT_NAME = "JSON-LD";

    public JSONLDGetFeatureResponse(GeoServer gs, TemplateLoader configuration) {
        super(gs, configuration, TemplateIdentifier.JSONLD);
        this.configuration = configuration;
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
        Object validator = null;
        try {
            EncodingHints encodingHints = new JSONLDOutputHelper().optionsToEncodingHints(featureCollection.getFeature());
            boolean validate = this.isSemanticValidation();
            if (validate) {
                this.validate(featureCollection, encodingHints, getFeature);
            }
            try (JSONLDWriter writer = (JSONLDWriter)this.helper.getOutputWriter(output);){
                this.write(featureCollection, writer, encodingHints, getFeature);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            if (validator != null) {
                validator.validate();
            }
        }
    }

    private void validate(FeatureCollectionResponse featureCollection, EncodingHints encodingHints, Operation operation) {
        JSONLDContextValidation validator = new JSONLDContextValidation();
        try (JSONLDWriter writer = (JSONLDWriter)this.helper.getOutputWriter(new FileOutputStream(validator.init()));){
            this.write(featureCollection, writer, encodingHints, operation);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        validator.validate();
    }

    private void write(FeatureCollectionResponse featureCollection, JSONLDWriter writer, EncodingHints encodingHints, Operation operation) throws IOException, ExecutionException {
        writer.startTemplateOutput(encodingHints);
        this.iterateFeatureCollection((TemplateOutputWriter)writer, featureCollection, operation);
        writer.endTemplateOutput(encodingHints);
    }

    @Override
    protected void beforeFeatureIteration(TemplateOutputWriter writer, RootBuilder root, FeatureTypeInfo typeInfo) {
        Boolean encodeAsString = (Boolean)root.getVendorOptions().get("encode_as_string", Boolean.class, (Object)false);
        JSONLDWriter jsonldWriter = (JSONLDWriter)writer;
        jsonldWriter.setEncodeAsString(encodeAsString.booleanValue());
    }

    @Override
    protected void beforeEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) {
    }

    @Override
    protected void writeAdditionalFieldsInternal(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature, BigInteger featureCount, ReferencedEnvelope bounds) throws IOException {
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return TemplateIdentifier.JSONLD.getOutputFormat();
    }

    private boolean isSemanticValidation() {
        Request request = (Request)Dispatcher.REQUEST.get();
        Map rawKvp = request.getRawKvp();
        Object value = rawKvp != null ? (Object)rawKvp.get("validation") : null;
        boolean result = false;
        if (value != null) {
            result = Boolean.valueOf(value.toString());
        }
        return result;
    }

    public String getCapabilitiesElementName() {
        return ELEMENT_NAME;
    }
}

