/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.io.EscapingWriterFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.utils.FeatureTypeInfoUtils;
import org.geoserver.featurestemplating.writers.GMLTemplateWriter;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.featurestemplating.writers.XHTMLTemplateWriter;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;

public class TemplateGetFeatureResponseHelper {
    private Catalog catalog;
    private TemplateIdentifier format;
    private static final String ESCAPE_CHARS = "escapeCharacters";

    TemplateGetFeatureResponseHelper(Catalog catalog, TemplateIdentifier format) {
        this.catalog = catalog;
        this.format = format;
    }

    TemplateOutputWriter getOutputWriter(OutputStream output) throws IOException {
        return this.getOutputWriter(output, null);
    }

    TemplateOutputWriter getOutputWriter(OutputStream output, String version) throws IOException {
        JSONLDWriter outputWriter;
        switch (this.format) {
            case JSON: 
            case GEOJSON: {
                outputWriter = new GeoJSONWriter(new JsonFactory().createGenerator(output, JsonEncoding.UTF8), this.format);
                break;
            }
            case JSONLD: {
                outputWriter = new JSONLDWriter(new JsonFactory().createGenerator(output, JsonEncoding.UTF8));
                break;
            }
            case GML2: 
            case GML31: 
            case GML32: 
            case HTML: {
                XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newDefaultFactory();
                if (xMLOutputFactory.isPropertySupported(ESCAPE_CHARS)) {
                    xMLOutputFactory.setProperty(ESCAPE_CHARS, false);
                }
                try {
                    XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(output, "UTF-8");
                    if (this.format.equals((Object)TemplateIdentifier.HTML)) {
                        outputWriter = new XHTMLTemplateWriter(xMLStreamWriter, output);
                        break;
                    }
                    outputWriter = new GMLTemplateWriter(xMLStreamWriter, version);
                    break;
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            default: {
                outputWriter = null;
            }
        }
        return outputWriter;
    }

    private static XMLOutputFactory getNonEscapingXmlOutputFactory() {
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        if (xMLOutputFactory.isPropertySupported(ESCAPE_CHARS)) {
            xMLOutputFactory.setProperty(ESCAPE_CHARS, false);
        } else {
            if (!(xMLOutputFactory instanceof WstxOutputFactory)) {
                xMLOutputFactory = new WstxOutputFactory();
            }
            ((WstxOutputFactory)xMLOutputFactory).getConfig().setTextEscaperFactory(new EscapingWriterFactory(){

                public Writer createEscapingWriterFor(Writer writer, String s) {
                    return writer;
                }

                public Writer createEscapingWriterFor(OutputStream outputStream, String s) {
                    return new OutputStreamWriter(outputStream);
                }
            });
        }
        return xMLOutputFactory;
    }

    FeatureTypeInfo getFirstFeatureTypeInfo(Object request) {
        FeatureTypeInfo result = request instanceof GetFeatureInfoRequest ? this.getFirstFeatureTypeInfo((GetFeatureInfoRequest)request) : this.getFirstFeatureTypeInfo(GetFeatureRequest.adapt((Object)request));
        return result;
    }

    FeatureTypeInfo getFirstFeatureTypeInfo(GetFeatureInfoRequest request) {
        Optional<MapLayerInfo> op = request.getQueryLayers().stream().filter(ml -> ml != null).findFirst();
        if (!op.isPresent()) {
            return null;
        }
        return op.get().getFeature();
    }

    FeatureTypeInfo getFirstFeatureTypeInfo(GetFeatureRequest request) {
        Query query = (Query)request.getQueries().get(0);
        QName typeName = (QName)query.getTypeNames().get(0);
        return this.getFeatureTypeInfo((Name)new NameImpl(typeName.getNamespaceURI(), typeName.getLocalPart()));
    }

    FeatureTypeInfo getFeatureTypeInfo(FeatureCollection collection) {
        return FeatureTypeInfoUtils.getFeatureTypeInfo((Catalog)this.catalog, (FeatureCollection)collection);
    }

    public FeatureTypeInfo getFeatureType(String collectionId) {
        return FeatureTypeInfoUtils.getFeatureTypeInfo((Catalog)this.catalog, (String)collectionId);
    }

    FeatureTypeInfo getFeatureTypeInfo(Name name) {
        return FeatureTypeInfoUtils.getFeatureTypeInfo((Catalog)this.catalog, (Name)name);
    }
}

