/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class GML3GetComplexFeatureTest
extends TemplateComplexTestSupport {
    private static final String MF_GML3 = "MappedFeatureGML31";
    private static final String MF_GML3_PARAM = "&MappedFeatureGML31=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeatureGML31.xml";
        this.setUpTemplate("requestParam('MappedFeatureGML31')='true'", SupportedFormat.GML, templateMappedFeature, MF_GML3, ".xml", "gsml", mappedFeature);
    }

    @Test
    public void getMappedFeature() throws IOException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml3&MappedFeatureGML31=true");
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathCount(5, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gml:name", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(4, "//gsml:lithology", doc);
    }

    @Test
    public void getMappedFeatureBackwardsMapping() throws IOException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml3&cql_filter=wfs:FeatureCollection.gml:featureMember.gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gsml:composition.gsml:CompositionPart.gsml:lithology.gsml:ControlledConcept.gsml:name = 'name_cc_3'&MappedFeatureGML31=true");
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
    }

    @Test
    public void getMappedFeatureHits() throws IOException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml3&resultType=hits&MappedFeatureGML31=true");
        this.assertXpathCount(0, "//gsml:MappedFeature", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathEvaluatesTo("5", "//wfs:FeatureCollection/@numberOfFeatures", doc);
    }
}

