/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class HTMLGetSimpleFeaturesResponseWFSTest
extends TemplateComplexTestSupport {
    static final QName HTML_FEATURES = new QName(CiteTestData.CITE_URI, "HtmlFeatures", CiteTestData.CITE_PREFIX);

    protected void onSetUp(SystemTestData testData) throws Exception {
        testData.addVectorLayer(HTML_FEATURES, Collections.emptyMap(), "HtmlFeatures.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo htmlFeatures = catalog.getFeatureTypeByName(HTML_FEATURES.getPrefix(), HTML_FEATURES.getLocalPart());
        String htmlTemplate = "HTMLHtmlFeature.xhtml";
        this.setUpTemplate("requestParam('html')='true'", SupportedFormat.HTML, htmlTemplate, "html-html-features", ".xhtml", HTML_FEATURES.getPrefix(), htmlFeatures);
    }

    @Test
    public void testHtmlResponse() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=cite:HtmlFeatures&outputFormat=");
        sb.append("text/html&cql_filter=NAME='Features1'&html=true");
        Document doc = this.getAsJSoup(sb.toString());
        Assert.assertEquals((long)1L, (long)doc.select("ul.nested li ul.nested li:contains(60\u00b0)").size());
    }
}

