/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAOImpl;
import org.geoserver.featurestemplating.configuration.TemplateService;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.util.IOUtils;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest"})
public class TemplateRestController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(TemplateRestController.class);

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xstream = persister.getXStream();
        xstream.alias("templatesInfo", TemplateInfoList.class);
        xstream.registerConverter((Converter)new TemplateInfoConverter());
        xstream.allowTypes(new Class[]{TemplateInfoList.class});
    }

    @Autowired
    public TemplateRestController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @PostMapping(value={"/featurestemplates", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates", "/workspaces/{ws}/featurestemplates"}, consumes={"text/xml", "application/xml", "application/json", "application/xhtml+xml", "text/json"})
    public ResponseEntity<String> templatePost(InputStream inputStream, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @RequestParam String templateName, @RequestHeader(value="Content-Type") String contentType, UriComponentsBuilder builder) {
        TemplateInfoDAOImpl dao;
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        String ftName = null;
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ftName = ft.getName();
            ws = ft.getStore().getWorkspace().getName();
        }
        if ((dao = TemplateInfoDAO.get()).findByFullName(templateName) != null) {
            throw new RestException("Template " + templateName + " already exists.", HttpStatus.FORBIDDEN);
        }
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName(templateName);
        info.setExtension(this.getExtensionByContentType(contentType));
        if (ws != null) {
            info.setWorkspace(ws);
        }
        if (ftName != null) {
            info.setFeatureType(ftName);
        }
        this.saveOrUpdateTemplate(info, inputStream);
        dao.saveOrUpdate(info);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUri(templateName, ws, ftName, builder));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)templateName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private String getExtensionByContentType(String contentType) {
        String mediaType = this.getMimeTypeFromContentType(contentType);
        String extension = this.getExtensionByMediaType(mediaType);
        if (extension == null) {
            throw new RestException("Unable to determine the template file extension.", HttpStatus.BAD_REQUEST);
        }
        return extension;
    }

    private String getExtensionByMediaType(String mediaType) {
        if (mediaType != null) {
            if (mediaType.equals("application/json") || mediaType.equals("text/json")) {
                return "json";
            }
            if (mediaType.equals("application/xml") || mediaType.equals("text/xml")) {
                return "xml";
            }
            if (mediaType.equals("application/xhtml+xml")) {
                return "xhtml";
            }
        }
        return null;
    }

    private String getMimeTypeFromContentType(String contentType) {
        if (contentType != null) {
            return contentType.split(";")[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/featurestemplates", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates", "/workspaces/{ws}/featurestemplates"}, consumes={"application/zip"})
    public ResponseEntity<String> templateZipPost(InputStream is, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @RequestParam(required=false) String templateName, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        String ftName = null;
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ftName = ft.getName();
            ws = ft.getStore().getWorkspace().getName();
        }
        TemplateInfo info = new TemplateInfo();
        if (ws != null) {
            info.setWorkspace(ws);
        }
        if (ftName != null) {
            info.setFeatureType(ftName);
        }
        File directory = this.unzip(is);
        try {
            File templateFile = this.getTemplateFileFromDirectory(directory);
            if (templateName == null) {
                templateName = FilenameUtils.removeExtension((String)templateFile.getName());
            }
            String extension = FilenameUtils.getExtension((String)templateFile.getName());
            TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
            if (dao.findByFullName(templateName) != null) {
                throw new RestException("Template " + templateName + " already exists.", HttpStatus.FORBIDDEN);
            }
            info.setTemplateName(templateName);
            info.setExtension(extension);
            try (FileInputStream inputStream = new FileInputStream(templateFile);){
                this.saveOrUpdateTemplate(info, inputStream);
            }
            catch (IOException e) {
                throw new RestException("Error while processing the template", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUri(templateName, ws, ftName, builder));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)templateName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/featurestemplates/{templateName}", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates/{templateName}", "/workspaces/{ws}/featurestemplates/{templateName}"}, consumes={"text/xml", "application/xml", "application/json", "application/xhtml+xml", "text/json"})
    public ResponseEntity<String> templatePut(InputStream inputStream, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @PathVariable String templateName, @RequestHeader(value="Content-Type") String contentType, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, templateName);
        TemplateInfo info = this.checkTemplateInfo(fullName);
        String extension = this.getExtensionByContentType(contentType);
        if (!info.getExtension().equals(extension)) {
            info.setExtension(extension);
            TemplateInfoDAO.get().saveOrUpdate(info);
        }
        this.saveOrUpdateTemplate(info, inputStream);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)templateName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/featurestemplates/{templateName}", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates/{templateName}", "/workspaces/{ws}/featurestemplates/{templateName}"}, consumes={"application/zip"})
    public ResponseEntity<String> templateZipPut(InputStream is, @PathVariable String templateName, @PathVariable(required=false) String ws, @PathVariable(required=false) String featureType) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, templateName);
        TemplateInfo info = this.checkTemplateInfo(fullName);
        File directory = this.unzip(is);
        try {
            File templateFile = this.getTemplateFileFromDirectory(directory);
            String extension = FilenameUtils.getExtension((String)templateFile.getName());
            if (!info.getExtension().equals(extension)) {
                info.setExtension(extension);
            }
            try (FileInputStream inputStream = new FileInputStream(templateFile);){
                this.saveOrUpdateTemplate(info, inputStream);
            }
            catch (IOException e) {
                throw new RestException("Error while processing the template", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)templateName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private TemplateInfo checkTemplateInfo(String fullName) {
        TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
        TemplateInfo info = dao.findByFullName(fullName);
        if (info == null) {
            throw new RestException("Template " + fullName + " doesn't exist.", HttpStatus.FORBIDDEN);
        }
        return info;
    }

    private URI getUri(String name, String workspace, String featureType, UriComponentsBuilder builder) {
        builder = builder.cloneBuilder();
        UriComponents uriComponents = featureType != null ? builder.path("/workspaces/{ws}/featuretypes/{featureType}/featurestemplates/{templateName}").buildAndExpand(new Object[]{workspace, featureType, name}) : (workspace != null ? builder.path("/workspaces/{ws}/featurestemplates/{templateName}").buildAndExpand(new Object[]{workspace, name}) : builder.path("/featurestemplates/{templateName}").buildAndExpand(new Object[]{name}));
        return uriComponents.toUri();
    }

    private void saveOrUpdateTemplate(TemplateInfo info, InputStream inputStream) {
        try {
            byte[] rawData = org.geoserver.rest.util.IOUtils.toByteArray((InputStream)inputStream);
            String content = new String(rawData, Charset.defaultCharset());
            new TemplateService().saveOrUpdate(info, content);
        }
        catch (IOException e) {
            throw new RestException("Error while writing the template", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/featurestemplates/{templateName}", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates/{templateName}", "/workspaces/{ws}/featurestemplates/{templateName}"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTemplate(@PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @PathVariable String templateName) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, templateName);
        TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
        TemplateInfo info = dao.findByFullName(fullName);
        new TemplateService().delete(info);
        LOGGER.info("Deleted template with name " + info.getFullName());
    }

    @GetMapping(value={"/featurestemplates/{templateName}", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates/{templateName}", "/workspaces/{ws}/featurestemplates/{templateName}"}, produces={"application/xml", "application/json", "application/xhtml+xml"})
    public void templateGet(@PathVariable(required=false) String ws, @PathVariable(required=false) String featureType, @PathVariable String templateName, HttpServletResponse response) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, templateName);
        TemplateInfo info = TemplateInfoDAO.get().findByFullName(fullName);
        Resource resource = TemplateFileManager.get().getTemplateResource(info);
        if (resource.getType() != Resource.Type.RESOURCE) {
            throw new RestException("Template with fullName " + info.getFullName() + " not found", HttpStatus.NOT_FOUND);
        }
        try {
            byte[] bytes = resource.getContents();
            response.setContentType(this.getMediaType(info));
            response.setContentLength(bytes.length);
            try (ServletOutputStream output = response.getOutputStream();){
                output.write(bytes);
                output.flush();
            }
        }
        catch (IOException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GetMapping(value={"/featurestemplates", "/workspaces/{ws}/featuretypes/{featureType}/featurestemplates", "/workspaces/{ws}/featurestemplates"}, produces={"text/xml", "application/xml", "application/json", "text/json"})
    public RestWrapper<TemplateInfoList> templateGetAll(@PathVariable(required=false) String ws, @PathVariable(required=false) String featureType, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        List<TemplateInfo> infos = TemplateInfoDAO.get().findAll().stream().filter(this.getPredicate(ws, featureType)).collect(Collectors.toList());
        return this.wrapObject(new TemplateInfoList(infos, builder), TemplateInfoList.class);
    }

    private Predicate<TemplateInfo> getPredicate(String ws, String featureType) {
        Predicate<TemplateInfo> predicate = featureType != null ? t -> t.getFeatureType() != null && t.getFeatureType().equals(featureType) : (ws != null ? t -> t.getWorkspace() != null && t.getWorkspace().equals(ws) && t.getFeatureType() == null : t -> t.getWorkspace() == null && t.getFeatureType() == null);
        return predicate;
    }

    private File unzip(InputStream object) {
        try {
            File tempDir = Files.createTempDirectory("_template", new FileAttribute[0]).toFile();
            IOUtils.decompress((InputStream)object, (File)tempDir);
            return tempDir;
        }
        catch (Exception e) {
            LOGGER.severe("Error processing the template zip (PUT): " + e.getMessage());
            throw new RestException("Error processing the template", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private File getTemplateFileFromDirectory(File directory) throws RestException {
        try {
            File[] matchingFiles = directory.listFiles((dir, name) -> name.endsWith("json") || name.endsWith("xml") || name.endsWith("xhtml"));
            if (matchingFiles == null || matchingFiles.length == 0) {
                throw new RestException("No template file provided:", HttpStatus.FORBIDDEN);
            }
            LOGGER.fine("getting template file from directory: " + matchingFiles[0].getAbsolutePath());
            return matchingFiles[0];
        }
        catch (Exception e) {
            LOGGER.severe("Error while searching the template in unzipped directory (PUT): " + e.getMessage());
            throw new RestException("Error processing the template", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String getMediaType(TemplateInfo info) {
        String result = info.getExtension().equals("json") ? "application/json" : (info.getExtension().equals("xhtml") ? "application/xhtml+xml" : "application/xml");
        return result;
    }

    private String buildFullName(String ws, String ft, String templateName) {
        StringBuilder fullName = new StringBuilder("");
        if (ws != null) {
            fullName.append(ws).append(":");
        }
        if (ft != null) {
            fullName.append(ft).append(":");
        }
        fullName.append(templateName);
        return fullName.toString();
    }

    private void checkWorkspaceName(String workspaceName) throws RestException {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
    }

    private FeatureTypeInfo checkFeatureType(String workspace, String featureTypeName) {
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName((Name)new NameImpl(workspace, featureTypeName));
        if (featureType == null) {
            throw new ResourceNotFoundException("FeatureType " + featureTypeName + " not found");
        }
        return featureType;
    }

    class TemplateInfoList {
        private List<TemplateInfo> infos;
        private UriComponentsBuilder builder;

        TemplateInfoList(List<TemplateInfo> infos, UriComponentsBuilder builder) {
            this.infos = infos;
            this.builder = builder;
        }

        List<TemplateInfo> getInfos() {
            return this.infos;
        }

        UriComponentsBuilder getUriBuilder() {
            return this.builder.cloneBuilder();
        }
    }

    class TemplateInfoConverter
    implements Converter {
        TemplateInfoConverter() {
        }

        public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            if (o instanceof TemplateInfoList) {
                TemplateInfoList list = (TemplateInfoList)o;
                for (TemplateInfo info : list.getInfos()) {
                    hierarchicalStreamWriter.startNode("templates");
                    hierarchicalStreamWriter.startNode("name");
                    hierarchicalStreamWriter.setValue(info.getTemplateName());
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.startNode("fileType");
                    hierarchicalStreamWriter.setValue(info.getExtension());
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.startNode("location");
                    String uri = TemplateRestController.this.getUri(info.getTemplateName(), info.getWorkspace(), info.getFeatureType(), list.getUriBuilder()).toString();
                    hierarchicalStreamWriter.setValue(uri);
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            return null;
        }

        public boolean canConvert(Class aClass) {
            return aClass.isAssignableFrom(TemplateInfoList.class);
        }
    }
}

