/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest.schema;

import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;

public class SchemaRestControllerTest
extends CatalogRESTTestSupport {
    private static final String JSON_SCHEMA = "{ \"schemaName\": \"foo\", \"template\": \"foo\" }";
    private static final String JSON_SCHEMA2 = "{ \"schemaName\": \"foo\", \"code\": \"foo\" }";

    @Test
    public void testPostGetPutGetDeleteJSON() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/schemaoverrides?schemaName=foo", JSON_SCHEMA, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/schemaoverrides/foo");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)JSON_SCHEMA.trim(), (Object)response.getContentAsString());
            response = this.putAsServletResponse("/rest/schemaoverrides/foo", JSON_SCHEMA2, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/schemaoverrides/foo");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)JSON_SCHEMA2.trim(), (Object)response.getContentAsString());
            response = this.deleteAsServletResponse("/rest/schemaoverrides/foo");
            Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
            Assert.assertNull((Object)TemplateInfoDAO.get().findByFullName("cdf:foo"));
        }
        finally {
            SchemaInfoDAO.get().deleteAll();
        }
    }
}

