/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest.schema;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.featurestemplating.configuration.schema.SchemaFileManager;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAOImpl;
import org.geoserver.featurestemplating.configuration.schema.SchemaService;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.util.IOUtils;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest"})
public class SchemaRestController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(SchemaRestController.class);

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xstream = persister.getXStream();
        xstream.alias("schemaInfo", SchemaInfoList.class);
        xstream.registerConverter((Converter)new SchemaInfoConverter());
        xstream.allowTypes(new Class[]{SchemaInfoList.class});
    }

    @Autowired
    public SchemaRestController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @PostMapping(value={"/schemaoverrides", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides", "/workspaces/{ws}/schemaoverrides"}, consumes={"text/xml", "application/xml", "application/json", "application/xhtml+xml", "text/json"})
    public ResponseEntity<String> schemaPost(InputStream inputStream, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @RequestParam String schemaName, @RequestHeader(value="Content-Type") String contentType, UriComponentsBuilder builder) {
        SchemaInfoDAOImpl dao;
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        String ftName = null;
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ftName = ft.getName();
            ws = ft.getStore().getWorkspace().getName();
        }
        if ((dao = SchemaInfoDAO.get()).findByFullName(schemaName) != null) {
            throw new RestException("Schema " + schemaName + " already exists.", HttpStatus.FORBIDDEN);
        }
        SchemaInfo info = new SchemaInfo();
        info.setSchemaName(schemaName);
        info.setExtension(this.getExtensionByContentType(contentType));
        if (ws != null) {
            info.setWorkspace(ws);
        }
        if (ftName != null) {
            info.setFeatureType(ftName);
        }
        this.saveOrUpdateSchema(info, inputStream);
        dao.saveOrUpdate(info);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUri(schemaName, ws, ftName, builder));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)schemaName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private String getExtensionByContentType(String contentType) {
        String mediaType = this.getMimeTypeFromContentType(contentType);
        String extension = this.getExtensionByMediaType(mediaType);
        if (extension == null) {
            throw new RestException("Unable to determine the schema file extension.", HttpStatus.BAD_REQUEST);
        }
        return extension;
    }

    private String getExtensionByMediaType(String mediaType) {
        if (mediaType != null) {
            if (mediaType.equals("application/json") || mediaType.equals("text/json")) {
                return "json";
            }
            if (mediaType.equals("application/xml") || mediaType.equals("text/xml")) {
                return "xml";
            }
            if (mediaType.equals("application/xhtml+xml")) {
                return "xhtml";
            }
        }
        return null;
    }

    private String getMimeTypeFromContentType(String contentType) {
        if (contentType != null) {
            return contentType.split(";")[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/schemaoverrides", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides", "/workspaces/{ws}/schemaoverrides"}, consumes={"application/zip"})
    public ResponseEntity<String> schemaZipPost(InputStream is, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @RequestParam(required=false) String schemaName, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        String ftName = null;
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ftName = ft.getName();
            ws = ft.getStore().getWorkspace().getName();
        }
        SchemaInfo info = new SchemaInfo();
        if (ws != null) {
            info.setWorkspace(ws);
        }
        if (ftName != null) {
            info.setFeatureType(ftName);
        }
        File directory = this.unzip(is);
        try {
            File schemaFile = this.getSchemaFileFromDirectory(directory);
            if (schemaName == null) {
                schemaName = FilenameUtils.removeExtension((String)schemaFile.getName());
            }
            String extension = FilenameUtils.getExtension((String)schemaFile.getName());
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            if (dao.findByFullName(schemaName) != null) {
                throw new RestException("Schema " + schemaName + " already exists.", HttpStatus.FORBIDDEN);
            }
            info.setSchemaName(schemaName);
            info.setExtension(extension);
            try (FileInputStream inputStream = new FileInputStream(schemaFile);){
                this.saveOrUpdateSchema(info, inputStream);
            }
            catch (IOException e) {
                throw new RestException("Error while processing the schema", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUri(schemaName, ws, ftName, builder));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)schemaName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/schemaoverrides/{schemaName}", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides/{schemaName}", "/workspaces/{ws}/schemaoverrides/{schemaName}"}, consumes={"text/xml", "application/xml", "application/json", "application/xhtml+xml", "text/json"})
    public ResponseEntity<String> schemaPut(InputStream inputStream, @PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @PathVariable String schemaName, @RequestHeader(value="Content-Type") String contentType, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, schemaName);
        SchemaInfo info = this.checkSchemaInfo(fullName);
        String extension = this.getExtensionByContentType(contentType);
        if (!info.getExtension().equals(extension)) {
            info.setExtension(extension);
            SchemaInfoDAO.get().saveOrUpdate(info);
        }
        this.saveOrUpdateSchema(info, inputStream);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)schemaName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/schemaoverrides/{schemaName}", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides/{schemaName}", "/workspaces/{ws}/schemaoverrides/{schemaName}"}, consumes={"application/zip"})
    public ResponseEntity<String> schemaZipPut(InputStream is, @PathVariable String schemaName, @PathVariable(required=false) String ws, @PathVariable(required=false) String featureType) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, schemaName);
        SchemaInfo info = this.checkSchemaInfo(fullName);
        File directory = this.unzip(is);
        try {
            File schemaFile = this.getSchemaFileFromDirectory(directory);
            String extension = FilenameUtils.getExtension((String)schemaFile.getName());
            if (!info.getExtension().equals(extension)) {
                info.setExtension(extension);
            }
            try (FileInputStream inputStream = new FileInputStream(schemaFile);){
                this.saveOrUpdateSchema(info, inputStream);
            }
            catch (IOException e) {
                throw new RestException("Error while processing the schema", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)schemaName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private SchemaInfo checkSchemaInfo(String fullName) {
        SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
        SchemaInfo info = dao.findByFullName(fullName);
        if (info == null) {
            throw new RestException("Schema " + fullName + " doesn't exist.", HttpStatus.FORBIDDEN);
        }
        return info;
    }

    private URI getUri(String name, String workspace, String featureType, UriComponentsBuilder builder) {
        builder = builder.cloneBuilder();
        UriComponents uriComponents = featureType != null ? builder.path("/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides/{schemaName}").buildAndExpand(new Object[]{workspace, featureType, name}) : (workspace != null ? builder.path("/workspaces/{ws}/schemaoverrides/{schemaName}").buildAndExpand(new Object[]{workspace, name}) : builder.path("/schemaoverrides/{schemaName}").buildAndExpand(new Object[]{name}));
        return uriComponents.toUri();
    }

    private void saveOrUpdateSchema(SchemaInfo info, InputStream inputStream) {
        try {
            byte[] rawData = org.geoserver.rest.util.IOUtils.toByteArray((InputStream)inputStream);
            String content = new String(rawData, Charset.defaultCharset());
            new SchemaService().saveOrUpdate(info, content);
        }
        catch (IOException e) {
            throw new RestException("Error while writing the schema", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/schemaoverrides/{schemaName}", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides/{schemaName}", "/workspaces/{ws}/schemaoverrides/{schemaName}"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteSchema(@PathVariable(required=false) String featureType, @PathVariable(required=false) String ws, @PathVariable String schemaName) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, schemaName);
        SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
        SchemaInfo info = dao.findByFullName(fullName);
        new SchemaService().delete(info);
        LOGGER.info("Deleted schema with name " + info.getFullName());
    }

    @GetMapping(value={"/schemaoverrides/{schemaName}", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides/{schemaName}", "/workspaces/{ws}/schemaoverrides/{schemaName}"}, produces={"application/xml", "application/json", "application/xhtml+xml"})
    public void schemaGet(@PathVariable(required=false) String ws, @PathVariable(required=false) String featureType, @PathVariable String schemaName, HttpServletResponse response) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        String fullName = this.buildFullName(ws, featureType, schemaName);
        SchemaInfo info = SchemaInfoDAO.get().findByFullName(fullName);
        Resource resource = SchemaFileManager.get().getSchemaResource(info);
        if (resource.getType() != Resource.Type.RESOURCE) {
            throw new RestException("Schema with fullName " + info.getFullName() + " not found", HttpStatus.NOT_FOUND);
        }
        try {
            byte[] bytes = resource.getContents();
            response.setContentType(this.getMediaType(info));
            response.setContentLength(bytes.length);
            try (ServletOutputStream output = response.getOutputStream();){
                output.write(bytes);
                output.flush();
            }
        }
        catch (IOException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GetMapping(value={"/schemaoverrides", "/workspaces/{ws}/featuretypes/{featureType}/schemaoverrides", "/workspaces/{ws}/schemaoverrides"}, produces={"text/xml", "application/xml", "application/json", "text/json"})
    public RestWrapper<SchemaInfoList> schemaGetAll(@PathVariable(required=false) String ws, @PathVariable(required=false) String featureType, UriComponentsBuilder builder) {
        if (ws != null) {
            this.checkWorkspaceName(ws);
            this.checkFullAdminRequired(ws);
        }
        if (featureType != null) {
            FeatureTypeInfo ft = this.checkFeatureType(ws, featureType);
            ws = ft.getStore().getWorkspace().getName();
            featureType = ft.getName();
        }
        List<SchemaInfo> infos = SchemaInfoDAO.get().findAll().stream().filter(this.getPredicate(ws, featureType)).collect(Collectors.toList());
        return this.wrapObject(new SchemaInfoList(infos, builder), SchemaInfoList.class);
    }

    private Predicate<SchemaInfo> getPredicate(String ws, String featureType) {
        Predicate<SchemaInfo> predicate = featureType != null ? t -> t.getFeatureType() != null && t.getFeatureType().equals(featureType) : (ws != null ? t -> t.getWorkspace() != null && t.getWorkspace().equals(ws) && t.getFeatureType() == null : t -> t.getWorkspace() == null && t.getFeatureType() == null);
        return predicate;
    }

    private File unzip(InputStream object) {
        try {
            File tempDir = Files.createTempDirectory("_schema", new FileAttribute[0]).toFile();
            IOUtils.decompress((InputStream)object, (File)tempDir);
            return tempDir;
        }
        catch (Exception e) {
            LOGGER.severe("Error processing the schema zip (PUT): " + e.getMessage());
            throw new RestException("Error processing the schema", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private File getSchemaFileFromDirectory(File directory) throws RestException {
        try {
            File[] matchingFiles = directory.listFiles((dir, name) -> name.endsWith("json") || name.endsWith("xml") || name.endsWith("xhtml"));
            if (matchingFiles == null || matchingFiles.length == 0) {
                throw new RestException("No schema file provided:", HttpStatus.FORBIDDEN);
            }
            LOGGER.fine("getting schema file from directory: " + matchingFiles[0].getAbsolutePath());
            return matchingFiles[0];
        }
        catch (Exception e) {
            LOGGER.severe("Error while searching the schema in unzipped directory (PUT): " + e.getMessage());
            throw new RestException("Error processing the schema", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String getMediaType(SchemaInfo info) {
        String result = info.getExtension().equals("json") ? "application/json" : (info.getExtension().equals("xhtml") ? "application/xhtml+xml" : "application/xml");
        return result;
    }

    private String buildFullName(String ws, String ft, String schemaName) {
        StringBuilder fullName = new StringBuilder("");
        if (ws != null) {
            fullName.append(ws).append(":");
        }
        if (ft != null) {
            fullName.append(ft).append(":");
        }
        fullName.append(schemaName);
        return fullName.toString();
    }

    private void checkWorkspaceName(String workspaceName) throws RestException {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
    }

    private FeatureTypeInfo checkFeatureType(String workspace, String featureTypeName) {
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName((Name)new NameImpl(workspace, featureTypeName));
        if (featureType == null) {
            throw new ResourceNotFoundException("FeatureType " + featureTypeName + " not found");
        }
        return featureType;
    }

    class SchemaInfoList {
        private List<SchemaInfo> infos;
        private UriComponentsBuilder builder;

        SchemaInfoList(List<SchemaInfo> infos, UriComponentsBuilder builder) {
            this.infos = infos;
            this.builder = builder;
        }

        List<SchemaInfo> getInfos() {
            return this.infos;
        }

        UriComponentsBuilder getUriBuilder() {
            return this.builder.cloneBuilder();
        }
    }

    class SchemaInfoConverter
    implements Converter {
        SchemaInfoConverter() {
        }

        public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            if (o instanceof SchemaInfoList) {
                SchemaInfoList list = (SchemaInfoList)o;
                for (SchemaInfo info : list.getInfos()) {
                    hierarchicalStreamWriter.startNode("schemas");
                    hierarchicalStreamWriter.startNode("name");
                    hierarchicalStreamWriter.setValue(info.getSchemaName());
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.startNode("fileType");
                    hierarchicalStreamWriter.setValue(info.getExtension());
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.startNode("location");
                    String uri = SchemaRestController.this.getUri(info.getSchemaName(), info.getWorkspace(), info.getFeatureType(), list.getUriBuilder()).toString();
                    hierarchicalStreamWriter.setValue(uri);
                    hierarchicalStreamWriter.endNode();
                    hierarchicalStreamWriter.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            return null;
        }

        public boolean canConvert(Class aClass) {
            return aClass.isAssignableFrom(SchemaInfoList.class);
        }
    }
}

