/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.web.TemplateRulesTabPanel;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateRuleConfigurationPanelTest
extends GeoServerWicketTestSupport {
    @Before
    public void setUpInternal() {
        TemplateInfo tinfo = new TemplateInfo();
        tinfo.setExtension("xml");
        tinfo.setTemplateName("test_template_xml");
        TemplateFileManager.get().saveTemplateFile(tinfo, "<ft:FeatureCollection/>");
        TemplateInfoDAO.get().saveOrUpdate(tinfo);
        tinfo = new TemplateInfo();
        tinfo.setExtension("json");
        tinfo.setTemplateName("test_template_json");
        TemplateFileManager.get().saveTemplateFile(tinfo, "features:[]");
        TemplateInfoDAO.get().saveOrUpdate(tinfo);
    }

    @Test
    public void testLayerRuleConfiguration() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.BUILDINGS));
        final Model layerModel = new Model((Serializable)layerInfo);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new TemplateRulesTabPanel(id, (IModel)layerModel);
            }
        }));
        FormTester form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("templateIdentifier", 0);
        form.select("outputFormats", 1);
        form.setValue("cqlFilter", "requestParam('myParam')='use this template'");
        form.submit("save");
        form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("templateIdentifier", 1);
        form.select("outputFormats", 1);
        form.setValue("priority", "1");
        form.setValue("cqlFilter", "requestParam('myParam2')='use this template'");
        form.submit("save");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testLayerRuleEdit() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.FIFTEEN));
        TemplateLayerConfig layerConfig = new TemplateLayerConfig();
        TemplateRule templateRule = new TemplateRule();
        List infos = TemplateInfoDAO.get().findAll();
        templateRule.setPriority(Integer.valueOf(0));
        templateRule.setTemplateName(((TemplateInfo)infos.get(0)).getFullName());
        templateRule.setTemplateIdentifier(((TemplateInfo)infos.get(0)).getIdentifier());
        templateRule.setCqlFilter("mimeType() = 'application/geo+json'");
        layerConfig.addTemplateRule(templateRule);
        layerInfo.getResource().getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
        final Model layerModel = new Model((Serializable)layerInfo);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new TemplateRulesTabPanel(id, (IModel)layerModel);
            }
        }));
        tester.executeAjaxEvent("form:panel:rulesTable:table:listContainer:items:1:itemProperties:1:component:link", "click");
        tester.assertModelValue("form:panel:ruleConfiguration:theForm:priority", (Object)templateRule.getPriority());
        DropDownChoice templateDropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:panel:ruleConfiguration:theForm:templateIdentifier");
        Assert.assertEquals((Object)((TemplateInfo)infos.get(0)).getIdentifier(), (Object)((TemplateInfo)templateDropDown.getModelObject()).getIdentifier());
        tester.assertModelValue("form:panel:ruleConfiguration:theForm:cqlFilter", (Object)templateRule.getCqlFilter());
        FormTester form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("outputFormats", 2);
        form.setValue("cqlFilter", "requestParam('myParam')='use this template'");
        form.submit("save");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testLayerRuleCQLValidation() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.BUILDINGS));
        final Model layerModel = new Model((Serializable)layerInfo);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new TemplateRulesTabPanel(id, (IModel)layerModel);
            }
        }));
        FormTester form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("templateIdentifier", 0);
        form.select("outputFormats", 1);
        form.setValue("cqlFilter", "requestParam('myParam')");
        form.submit("save");
        tester.assertErrorMessages(new Serializable[]{"The Request CQL filter is invalid. Error is:  Expecting Filter Parsing : requestParam('myParam')."});
    }

    @Test
    public void testIncompatibleOutputFormat() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.FIFTEEN));
        TemplateLayerConfig layerConfig = new TemplateLayerConfig();
        TemplateRule templateRule = new TemplateRule();
        List infos = TemplateInfoDAO.get().findAll();
        templateRule.setPriority(Integer.valueOf(0));
        templateRule.setTemplateName(((TemplateInfo)infos.get(1)).getFullName());
        templateRule.setTemplateIdentifier(((TemplateInfo)infos.get(1)).getIdentifier());
        templateRule.setCqlFilter("mimeType() = 'application/geo+json'");
        layerConfig.addTemplateRule(templateRule);
        layerInfo.getResource().getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
        final Model layerModel = new Model((Serializable)layerInfo);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new TemplateRulesTabPanel(id, (IModel)layerModel);
            }
        }));
        tester.executeAjaxEvent("form:panel:rulesTable:table:listContainer:items:1:itemProperties:1:component:link", "click");
        tester.assertModelValue("form:panel:ruleConfiguration:theForm:priority", (Object)templateRule.getPriority());
        tester.assertModelValue("form:panel:ruleConfiguration:theForm:cqlFilter", (Object)templateRule.getCqlFilter());
        FormTester form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("outputFormats", 0);
        form.setValue("cqlFilter", "requestParam('myParam')='use this template'");
        form.submit("save");
        tester.assertErrorMessages(new Serializable[]{"The Template extension and the chosen output format are incompatible."});
    }

    @Test
    public void testLayerRuleProfileCQL() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES));
        final Model layerModel = new Model((Serializable)layerInfo);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new TemplateRulesTabPanel(id, (IModel)layerModel);
            }
        }));
        FormTester form = tester.newFormTester("form:panel:ruleConfiguration:theForm");
        form.select("templateIdentifier", 0);
        form.select("outputFormats", 0);
        form.setValue("profileFilter", "header('Contet-Profile')='http://myProfile'");
        form.submit("save");
        tester.assertNoErrorMessage();
    }
}

