/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.wicket.Component;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.FeatureTypeTemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAOImpl;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.web.TemplateRuleConfigurationPanel;
import org.geoserver.featurestemplating.web.TemplateRulesTablePanel;
import org.geoserver.web.publish.PublishedEditTabPanel;

public class TemplateRulesTabPanel
extends PublishedEditTabPanel<LayerInfo> {
    public TemplateRuleConfigurationPanel configurationPanel;

    public TemplateRulesTabPanel(String id, IModel<LayerInfo> model) {
        super(id, model);
        LayerInfo li = (LayerInfo)model.getObject();
        ResourceInfo ri = li.getResource();
        if (!(ri instanceof FeatureTypeInfo)) {
            this.configurationPanel.setEnabled(false);
        }
        TemplateInfoDAOImpl infoDao = TemplateInfoDAO.get();
        FeatureTypeTemplateDAOListener listener = new FeatureTypeTemplateDAOListener((FeatureTypeInfo)ri);
        infoDao.addTemplateListener((TemplateDAOListener)listener);
        PropertyModel resource = new PropertyModel(model, "resource");
        PropertyModel metadata = new PropertyModel((Object)resource, "metadata");
        TemplateRulesTablePanel tablePanel = new TemplateRulesTablePanel("rulesTable", (IModel<MetadataMap>)metadata);
        tablePanel.setOutputMarkupId(true);
        this.add(new Component[]{tablePanel});
        this.configurationPanel = new TemplateRuleConfigurationPanel("ruleConfiguration", (CompoundPropertyModel<TemplateRule>)new CompoundPropertyModel((Object)new TemplateRule()), false, li);
        this.configurationPanel.setTemplateRuleTablePanel(tablePanel);
        this.configurationPanel.setOutputMarkupId(true);
        tablePanel.setConfigurationPanel(this.configurationPanel);
        this.add(new Component[]{this.configurationPanel});
    }

    public void beforeSave() {
        super.beforeSave();
    }

    public void save() throws IOException {
        TemplateRule ruleModel = (TemplateRule)this.configurationPanel.templateRuleModel.getObject();
        HashSet<TemplateRule> rules = new HashSet<TemplateRule>((Collection)this.configurationPanel.tablePanel.getModel().getObject());
        rules.add(ruleModel);
        this.configurationPanel.tablePanel.getModel().setObject(rules);
        super.save();
    }
}

