/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.featurestemplating.configuration.FileTemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateDAOListener;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateService;
import org.geoserver.featurestemplating.web.TemplateConfigurationPage;
import org.geoserver.featurestemplating.web.TemplateInfoProvider;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class TemplateInfoPage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<TemplateInfo> tablePanel;
    private AjaxLink<Object> remove;

    public TemplateInfoPage() {
        this.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = -4136656891019857299L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new TemplateConfigurationPage((IModel<TemplateInfo>)new Model((Serializable)new TemplateInfo()), true));
            }
        }});
        Component[] componentArray = new Component[1];
        this.remove = this.newRemoveLink();
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.tablePanel = new GeoServerTablePanel<TemplateInfo>("tablePanel", (GeoServerDataProvider)new TemplateInfoProvider(), true){

            protected Component getComponentForProperty(String id, IModel<TemplateInfo> itemModel, GeoServerDataProvider.Property<TemplateInfo> property) {
                if (property.equals(TemplateInfoProvider.NAME)) {
                    return new SimpleAjaxLink<TemplateInfo>(id, itemModel, TemplateInfoProvider.NAME.getModel(itemModel)){

                        protected void onClick(AjaxRequestTarget target) {
                            this.setResponsePage((IRequestablePage)new TemplateConfigurationPage((IModel<TemplateInfo>)this.getModel(), false));
                        }
                    };
                }
                if (property.equals(TemplateInfoProvider.EXTENSION)) {
                    return new Label(id, TemplateInfoProvider.EXTENSION.getModel(itemModel));
                }
                if (property.equals(TemplateInfoProvider.WORKSPACE)) {
                    return new Label(id, TemplateInfoProvider.WORKSPACE.getModel(itemModel));
                }
                if (property.equals(TemplateInfoProvider.FEATURE_TYPE_INFO)) {
                    return new Label(id, TemplateInfoProvider.FEATURE_TYPE_INFO.getModel(itemModel));
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                TemplateInfoPage.this.remove.setEnabled(TemplateInfoPage.this.tablePanel.getSelection().size() > 0);
                target.add(new Component[]{TemplateInfoPage.this.remove});
            }
        };
        this.tablePanel.setOutputMarkupId(true);
        this.tablePanel.setEnabled(true);
        this.add(new Component[]{this.tablePanel});
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        TemplateInfoDAO.get().addTemplateListener((TemplateDAOListener)new FileTemplateDAOListener());
    }

    private AjaxLink<Object> newRemoveLink() {
        return new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                TemplateService service = new TemplateService();
                List templates = TemplateInfoPage.this.tablePanel.getSelection();
                templates.forEach(ti -> service.delete(ti));
                TemplateInfoPage.this.tablePanel.modelChanged();
                target.add(new Component[]{TemplateInfoPage.this.tablePanel});
                target.add(new Component[]{TemplateInfoPage.this});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener ajaxCall = new AjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        CharSequence message = new ParamResourceModel("confirmRemove", (Component)TemplateInfoPage.this, new Object[0]).getString();
                        message = JavaScriptUtils.escapeQuotes((CharSequence)message);
                        return "return confirm('" + message + "');";
                    }
                };
                attributes.getAjaxCallListeners().add(ajaxCall);
            }
        };
    }
}

