/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.web.TemplateRuleConfigurationPanel;
import org.geoserver.featurestemplating.web.TemplateRuleProvider;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class TemplateRulesTablePanel
extends Panel {
    private GeoServerTablePanel<TemplateRule> table;
    private AjaxLink<Object> remove;
    private TemplateRuleConfigurationPanel configurationPanel;
    private LiveCollectionModel<TemplateRule, Set<TemplateRule>> model;

    public TemplateRulesTablePanel(String id, IModel<MetadataMap> metadataModel) {
        super(id);
        MapModel mapModelLayerConf = new MapModel(metadataModel, "FEATURES_TEMPLATING_LAYER_CONF");
        if (mapModelLayerConf.getObject() == null) {
            mapModelLayerConf.setObject((Object)new TemplateLayerConfig());
        }
        this.model = LiveCollectionModel.set((IModel)new PropertyModel((Object)mapModelLayerConf, "templateRules"));
        TemplateRuleProvider dataProvider = new TemplateRuleProvider(this.model);
        this.table = new TemplateRuleTable("table", dataProvider, true);
        this.table.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.remove = new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                Set rules = (Set)TemplateRulesTablePanel.this.getModel().getObject();
                HashSet updated = new HashSet(rules);
                updated.removeAll(TemplateRulesTablePanel.this.table.getSelection());
                TemplateRulesTablePanel.this.getModel().setObject(updated);
                TemplateRulesTablePanel.this.modelChanged();
                TemplateRulesTablePanel.this.table.modelChanged();
                target.add(new Component[]{TemplateRulesTablePanel.this.table});
            }
        };
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.add(new Component[]{this.table});
    }

    public LiveCollectionModel<TemplateRule, Set<TemplateRule>> getModel() {
        return this.model;
    }

    public GeoServerTablePanel<TemplateRule> getTable() {
        return this.table;
    }

    public void setConfigurationPanel(TemplateRuleConfigurationPanel panel) {
        this.configurationPanel = panel;
    }

    public class TemplateRuleTable
    extends GeoServerTablePanel<TemplateRule> {
        public TemplateRuleTable(String id, GeoServerDataProvider<TemplateRule> dataProvider, boolean selectable) {
            super(id, dataProvider, selectable);
        }

        protected Component getComponentForProperty(String id, final IModel<TemplateRule> itemModel, GeoServerDataProvider.Property<TemplateRule> property) {
            if (property.equals(TemplateRuleProvider.PRIORITY)) {
                return new Label(id, TemplateRuleProvider.PRIORITY.getModel(itemModel));
            }
            if (property.equals(TemplateRuleProvider.NAME)) {
                return new SimpleAjaxLink<TemplateRule>(id, itemModel, TemplateRuleProvider.NAME.getModel(itemModel)){

                    protected void onClick(AjaxRequestTarget target) {
                        TemplateRule rule = (TemplateRule)itemModel.getObject();
                        TemplateRulesTablePanel.this.configurationPanel.theForm.getModel().setObject((Object)rule);
                        TemplateRulesTablePanel.this.configurationPanel.theForm.modelChanged();
                        String submitLabel = TemplateRulesTablePanel.this.configurationPanel.getSubmitLabelValue("update");
                        TemplateRulesTablePanel.this.configurationPanel.submitLabelModel.setObject((Serializable)((Object)submitLabel));
                        String panelLabel = TemplateRulesTablePanel.this.configurationPanel.getPanelLabelValue("update");
                        TemplateRulesTablePanel.this.configurationPanel.panelLabelModel.setObject((Serializable)((Object)panelLabel));
                        target.add(new Component[]{TemplateRulesTablePanel.this.configurationPanel.theForm});
                        target.add(new Component[]{TemplateRulesTablePanel.this.configurationPanel.submitLabel});
                        target.add(new Component[]{TemplateRulesTablePanel.this.configurationPanel.panelLabel});
                    }
                };
            }
            if (property.equals(TemplateRuleProvider.OUTPUT_FORMAT)) {
                return new Label(id, TemplateRuleProvider.OUTPUT_FORMAT.getModel(itemModel));
            }
            if (property.equals(TemplateRuleProvider.CQL_FILTER)) {
                return new Label(id, TemplateRuleProvider.CQL_FILTER.getModel(itemModel));
            }
            if (property.equals(TemplateRuleProvider.PROFILE_FILTER)) {
                return new Label(id, TemplateRuleProvider.PROFILE_FILTER.getModel(itemModel));
            }
            return null;
        }
    }
}

