/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.PanelCachingTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.featurestemplating.configuration.schema.SchemaFileManager;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaService;
import org.geoserver.featurestemplating.web.schema.SchemaInfoDataPanel;
import org.geoserver.featurestemplating.web.schema.SchemaInfoPage;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.CodeMirrorEditor;

public class SchemaConfigurationPage
extends GeoServerSecuredPage {
    protected AjaxTabbedPanel<ITab> schemaPanel;
    private boolean isNew;
    CodeMirrorEditor editor;
    private Form<SchemaInfo> form;
    private SchemaInfoDataPanel dataPanel;
    String rawSchema;

    public SchemaConfigurationPage(IModel<SchemaInfo> model, boolean isNew) {
        this.isNew = isNew;
        this.initUI(model);
    }

    private void initUI(IModel<SchemaInfo> model) {
        this.form = new Form("schemaForm", model);
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        PanelCachingTab dataTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Data"))){

            public Panel getPanel(String id) {
                SchemaConfigurationPage.this.dataPanel = new SchemaInfoDataPanel(id, SchemaConfigurationPage.this);
                return SchemaConfigurationPage.this.dataPanel;
            }
        });
        tabs.add((ITab)dataTab);
        this.schemaPanel = this.newTabbedPanel(tabs);
        this.schemaPanel.setMarkupId("schema-info-tabbed-panel");
        this.schemaPanel.setOutputMarkupId(true);
        this.form.add(new Component[]{this.schemaPanel});
        this.rawSchema = this.getStringSchema((SchemaInfo)model.getObject());
        String mode = !this.isNew && ((SchemaInfo)model.getObject()).getExtension().equals("json") ? "javascript" : "xml";
        this.editor = new CodeMirrorEditor("schemaEditor", mode, (IModel)new PropertyModel((Object)this, "rawSchema")){

            public boolean isRequired() {
                boolean result = false;
                IFormSubmittingComponent submitter = SchemaConfigurationPage.this.form.getRootForm().findSubmitter();
                if (submitter != null) {
                    result = !submitter.equals(SchemaConfigurationPage.this.dataPanel.getUploadLink());
                }
                return result;
            }
        };
        this.form.add(new Component[]{this.editor});
        if (mode.equals("javascript")) {
            this.editor.setModeAndSubMode(mode, ((SchemaInfo)model.getObject()).getExtension());
        }
        this.editor.setMarkupId("schemaEditor");
        this.editor.setTextAreaMarkupId("editor");
        this.editor.setOutputMarkupId(true);
        this.form.setMultiPart(true);
        this.form.add(new Component[]{this.editor});
        this.form.add(new Component[]{this.getSubmit()});
        this.form.add(new Component[]{new Link<SchemaInfoPage>("cancel"){

            public void onClick() {
                SchemaConfigurationPage.this.doReturn(SchemaInfoPage.class);
            }
        }});
        this.add(new Component[]{this.form});
    }

    private String getStringSchema(SchemaInfo schemaInfo) {
        String rawSchema = "";
        if (!this.isNew) {
            Resource resource = SchemaFileManager.get().getSchemaResource(schemaInfo);
            try {
                rawSchema = FileUtils.readFileToString((File)resource.file(), (Charset)Charset.forName("UTF-8"));
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        return rawSchema;
    }

    public String getStringSchemaFromInput() {
        String rawSchema = this.getEditor().getInput();
        if (rawSchema == null || rawSchema.trim().equals("")) {
            rawSchema = (String)this.getEditor().getModelObject();
        }
        return rawSchema;
    }

    public void setRawSchema(Reader in) throws IOException {
        try (BufferedReader bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);){
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = bin.readLine()) != null) {
                builder.append(line).append("\n");
            }
            this.rawSchema = builder.toString();
            this.editor.setModelObject((Object)this.rawSchema);
        }
    }

    private AjaxSubmitLink getSubmit() {
        AjaxSubmitLink submitLink = new AjaxSubmitLink("save", this.form){

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                SchemaConfigurationPage.this.clearFeedbackMessages();
                SchemaInfo templateInfo = (SchemaInfo)SchemaConfigurationPage.this.form.getModelObject();
                target.add(new Component[]{SchemaConfigurationPage.this.topFeedbackPanel});
                target.add(new Component[]{SchemaConfigurationPage.this.bottomFeedbackPanel});
                String rawTemplate = SchemaConfigurationPage.this.rawSchema;
                SchemaConfigurationPage.this.saveSchemaInfo(templateInfo, rawTemplate);
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                super.onAfterSubmit(target);
                SchemaConfigurationPage.this.doReturn(SchemaInfoPage.class);
            }

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                SchemaConfigurationPage.this.addFeedbackPanels(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(SchemaConfigurationPage.this.editor.getSaveDecorator());
            }
        };
        return submitLink;
    }

    public void setRawSchema(String rawTemplate) {
        this.rawSchema = rawTemplate;
    }

    public String getRawSchema() {
        return this.rawSchema;
    }

    Form<SchemaInfo> getForm() {
        return this.form;
    }

    public IModel<SchemaInfo> getSchemaInfoModel() {
        return this.form.getModel();
    }

    void saveSchemaInfo(SchemaInfo schemaInfo, String rawTemplate) {
        new SchemaService().saveOrUpdate(schemaInfo, rawTemplate);
    }

    public CodeMirrorEditor getEditor() {
        return this.editor;
    }

    private void clearFeedbackMessages() {
        this.topFeedbackPanel.getFeedbackMessages().clear();
        this.bottomFeedbackPanel.getFeedbackMessages().clear();
    }

    private AjaxTabbedPanel<ITab> newTabbedPanel(List<ITab> tabs) {
        return new AjaxTabbedPanel<ITab>("schemaPanel", tabs){

            protected String getTabContainerCssClass() {
                return "tab-row tab-row-compact";
            }

            protected WebMarkupContainer newLink(String linkId, final int index) {
                AjaxSubmitLink link = new AjaxSubmitLink(linkId){
                    private static final long serialVersionUID = 4599409150448651749L;

                    public void onSubmit(AjaxRequestTarget target) {
                        SchemaInfo schemaInfo = (SchemaInfo)SchemaConfigurationPage.this.form.getModelObject();
                        String rawSchema = SchemaConfigurationPage.this.getStringSchemaFromInput();
                        SchemaConfigurationPage.this.saveSchemaInfo(schemaInfo, rawSchema);
                        this.setSelectedTab(index);
                        target.add(new Component[]{SchemaConfigurationPage.this.schemaPanel});
                    }

                    protected void onError(AjaxRequestTarget target) {
                        SchemaConfigurationPage.this.addFeedbackPanels(target);
                    }
                };
                return link;
            }
        };
    }
}

