/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.web.schema.SchemaConfigurationPage;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;

public class SchemaInfoDataPanel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(SchemaInfoDataPanel.class);
    private SchemaConfigurationPage page;
    private IModel<SchemaInfo> model;
    private TextField<String> schemaName;
    private DropDownChoice<String> wsDropDown;
    private DropDownChoice<String> templateExtension;
    private DropDownChoice<String> ftiDropDown;
    private FileUploadField fileUploadField;
    private AjaxSubmitLink uploadLink;

    public SchemaInfoDataPanel(String id, SchemaConfigurationPage page) {
        super(id);
        this.page = page;
        this.model = page.getSchemaInfoModel();
        this.initUI();
    }

    private void initUI() {
        this.schemaName = new TextField("schemaName", (IModel)new PropertyModel(this.model, "schemaName"));
        this.schemaName.setOutputMarkupId(true);
        this.schemaName.setRequired(true);
        this.add(new Component[]{this.schemaName});
        this.templateExtension = new DropDownChoice("extension", (IModel)new PropertyModel(this.model, "extension"), this.getExtensions());
        final CodeMirrorEditor editor = this.page.getEditor();
        this.templateExtension.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
                String mode = (String)SchemaInfoDataPanel.this.templateExtension.getConvertedInput();
                if (mode != null && (mode.equals("xml") || mode.equals("xhtml"))) {
                    editor.setMode("xml");
                } else if (SchemaInfoDataPanel.this.isJsonLd(editor)) {
                    editor.setModeAndSubMode("javascript", "jsonld");
                } else {
                    editor.setModeAndSubMode("javascript", mode);
                }
                ajaxRequestTarget.add(new Component[]{editor});
            }
        }});
        this.templateExtension.setRequired(true);
        this.add(new Component[]{this.templateExtension});
        this.wsDropDown = new DropDownChoice("workspace", (IModel)new PropertyModel(this.model, "workspace"), this.getWorkspaces());
        this.wsDropDown.setNullValid(true);
        this.wsDropDown.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 732177308220189475L;

            protected void onUpdate(AjaxRequestTarget target) {
                String workspace = (String)SchemaInfoDataPanel.this.wsDropDown.getConvertedInput();
                SchemaInfoDataPanel.this.ftiDropDown.setChoices(SchemaInfoDataPanel.this.getFeatureTypesInfo(workspace));
                SchemaInfoDataPanel.this.ftiDropDown.modelChanged();
                target.add(new Component[]{SchemaInfoDataPanel.this.ftiDropDown});
                SchemaInfoDataPanel.this.ftiDropDown.setEnabled(true);
            }
        }});
        this.add(new Component[]{this.wsDropDown});
        this.ftiDropDown = new DropDownChoice("featureTypeInfo", (IModel)new PropertyModel(this.model, "featureType"), Collections.emptyList());
        if (this.wsDropDown.getValue() == null || this.wsDropDown.getValue() == "-1") {
            this.ftiDropDown.setEnabled(false);
        } else {
            this.ftiDropDown.setChoices(this.getFeatureTypesInfo((String)this.wsDropDown.getModelObject()));
        }
        this.ftiDropDown.setOutputMarkupId(true);
        this.ftiDropDown.setNullValid(true);
        this.add(new Component[]{this.ftiDropDown});
        this.fileUploadField = new FileUploadField("filename");
        this.fileUploadField.setDefaultModel((IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{this.fileUploadField});
        this.uploadLink = this.uploadLink();
        this.add(new Component[]{this.uploadLink});
    }

    private List<String> getWorkspaces() {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        return catalog.getWorkspaces().stream().map(w -> w.getName()).collect(Collectors.toList());
    }

    private List<String> getExtensions() {
        return Arrays.asList("xml", "xhtml", "json");
    }

    private List<String> getFeatureTypesInfo(String workspaceName) {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(workspaceName);
        return catalog.getFeatureTypesByNamespace(namespaceInfo).stream().map(fti -> fti.getName()).collect(Collectors.toList());
    }

    AjaxSubmitLink uploadLink() {
        return new ConfirmOverwriteSubmitLink("upload", (Form)this.page.getForm()){
            private static final long serialVersionUID = 658341311654601761L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload upload = SchemaInfoDataPanel.this.fileUploadField.getFileUpload();
                if (upload == null) {
                    this.warn((Serializable)((Object)"No file selected."));
                    return;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)upload.getInputStream(), (OutputStream)bout);
                    SchemaInfoDataPanel.this.page.getEditor().reset();
                    SchemaInfoDataPanel.this.page.setRawSchema(new InputStreamReader((InputStream)new ByteArrayInputStream(bout.toByteArray()), "UTF-8"));
                    upload.getContentType();
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (Exception e) {
                    SchemaInfoDataPanel.this.page.error((Serializable)((Object)("Errors occurred uploading the '" + upload.getClientFileName() + "' template")));
                    LOGGER.log(Level.WARNING, "Errors occurred uploading the '" + upload.getClientFileName() + "' template", e);
                }
                SchemaInfo schemaInfo = (SchemaInfo)SchemaInfoDataPanel.this.model.getObject();
                String fileName = upload.getClientFileName();
                if (schemaInfo.getSchemaName() == null || "".equals(schemaInfo.getSchemaName().trim())) {
                    SchemaInfoDataPanel.this.schemaName.setModelValue(new String[]{ResponseUtils.stripExtension((String)fileName)});
                }
                int index = fileName.lastIndexOf(".");
                String extension = fileName.substring(index + 1);
                schemaInfo.setExtension(extension);
                CodeMirrorEditor editor = SchemaInfoDataPanel.this.page.getEditor();
                if (!extension.equals("xml")) {
                    if (SchemaInfoDataPanel.this.isJsonLd(editor)) {
                        editor.setModeAndSubMode("javascript", "jsonld");
                    } else {
                        editor.setModeAndSubMode("javascript", "json");
                    }
                } else {
                    editor.setMode(extension);
                }
                editor.modelChanged();
                SchemaInfoDataPanel.this.schemaName.modelChanged();
                SchemaInfoDataPanel.this.templateExtension.modelChanged();
                target.add(new Component[]{editor});
                target.add(new Component[]{SchemaInfoDataPanel.this.page});
            }
        };
    }

    boolean isJsonLd(CodeMirrorEditor editor) {
        String template = (String)editor.getModelObject();
        return template != null && !template.equals("") && template.contains("@context");
    }

    public AjaxSubmitLink getUploadLink() {
        return this.uploadLink;
    }

    class ConfirmOverwriteSubmitLink
    extends AjaxSubmitLink {
        private static final long serialVersionUID = 2673499149884774636L;

        public ConfirmOverwriteSubmitLink(String id, Form<?> form) {
            super(id, form);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                private static final long serialVersionUID = 8637613472102572505L;

                public CharSequence getPrecondition(Component component) {
                    CharSequence message = new ParamResourceModel("confirmOverwrite", (Component)SchemaInfoDataPanel.this, new Object[0]).getString();
                    message = JavaScriptUtils.escapeQuotes((CharSequence)message);
                    return "var val = attrs.event.view.document.gsEditors ? attrs.event.view.document.gsEditors." + SchemaInfoDataPanel.this.page.getEditor().getTextAreaMarkupId() + ".getValue() : attrs.event.view.document.getElementById(\"" + SchemaInfoDataPanel.this.page.getEditor().getTextAreaMarkupId() + "\").value; if(val != '' &&!confirm('" + message + "')) return false;";
                }
            });
        }

        public boolean getDefaultFormProcessing() {
            return false;
        }
    }
}

