/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web.schema;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.featurestemplating.configuration.schema.FileSchemaDAOListener;
import org.geoserver.featurestemplating.configuration.schema.SchemaDAOListener;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaService;
import org.geoserver.featurestemplating.web.schema.SchemaConfigurationPage;
import org.geoserver.featurestemplating.web.schema.SchemaInfoProvider;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class SchemaInfoPage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<SchemaInfo> tablePanel;
    private GeoServerTablePanel<SchemaInfo> schemaPanel;
    private GeoServerTablePanel<SchemaInfo> schemaTablePanel;
    private AjaxLink<Object> remove;

    public SchemaInfoPage() {
        this.addFeatureTeplateSection();
        this.addSchemaDefinitionSection();
    }

    private void addFeatureTeplateSection() {
        this.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = -4136656891019857299L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new SchemaConfigurationPage((IModel<SchemaInfo>)new Model((Serializable)new SchemaInfo()), true));
            }
        }});
        Component[] componentArray = new Component[1];
        this.remove = this.newRemoveLink();
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.tablePanel = new GeoServerTablePanel<SchemaInfo>("tablePanel", (GeoServerDataProvider)new SchemaInfoProvider(), true){

            protected Component getComponentForProperty(String id, IModel<SchemaInfo> itemModel, GeoServerDataProvider.Property<SchemaInfo> property) {
                if (property.equals(SchemaInfoProvider.NAME)) {
                    return new SimpleAjaxLink<SchemaInfo>(id, itemModel, SchemaInfoProvider.NAME.getModel(itemModel)){

                        protected void onClick(AjaxRequestTarget target) {
                            this.setResponsePage((IRequestablePage)new SchemaConfigurationPage((IModel<SchemaInfo>)this.getModel(), false));
                        }
                    };
                }
                if (property.equals(SchemaInfoProvider.EXTENSION)) {
                    return new Label(id, SchemaInfoProvider.EXTENSION.getModel(itemModel));
                }
                if (property.equals(SchemaInfoProvider.WORKSPACE)) {
                    return new Label(id, SchemaInfoProvider.WORKSPACE.getModel(itemModel));
                }
                if (property.equals(SchemaInfoProvider.FEATURE_TYPE_INFO)) {
                    return new Label(id, SchemaInfoProvider.FEATURE_TYPE_INFO.getModel(itemModel));
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                SchemaInfoPage.this.remove.setEnabled(SchemaInfoPage.this.tablePanel.getSelection().size() > 0);
                target.add(new Component[]{SchemaInfoPage.this.remove});
            }
        };
        this.tablePanel.setOutputMarkupId(true);
        this.tablePanel.setEnabled(true);
        this.add(new Component[]{this.tablePanel});
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        SchemaInfoDAO.get().addSchemaListener((SchemaDAOListener)new FileSchemaDAOListener());
    }

    private void addSchemaDefinitionSection() {
        this.add(new Component[]{new AjaxLink<Object>("addNewSchema"){
            private static final long serialVersionUID = -4136656891019857299L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new SchemaConfigurationPage((IModel<SchemaInfo>)new Model((Serializable)new SchemaInfo()), true));
            }
        }});
    }

    private AjaxLink<Object> newRemoveSchemaLink() {
        return new AjaxLink<Object>("removeSelectedSchema"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                SchemaService service = new SchemaService();
                List schemaInfos = SchemaInfoPage.this.schemaPanel.getSelection();
                schemaInfos.forEach(ti -> service.delete(ti));
                SchemaInfoPage.this.tablePanel.modelChanged();
                target.add(new Component[]{SchemaInfoPage.this.tablePanel});
                target.add(new Component[]{SchemaInfoPage.this});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener ajaxCall = new AjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        CharSequence message = new ParamResourceModel("confirmRemove", (Component)SchemaInfoPage.this, new Object[0]).getString();
                        message = JavaScriptUtils.escapeQuotes((CharSequence)message);
                        return "return confirm('" + message + "');";
                    }
                };
                attributes.getAjaxCallListeners().add(ajaxCall);
            }
        };
    }

    private AjaxLink<Object> newRemoveLink() {
        return new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                SchemaService service = new SchemaService();
                List schemaInfos = SchemaInfoPage.this.tablePanel.getSelection();
                schemaInfos.forEach(si -> service.delete(si));
                SchemaInfoPage.this.tablePanel.modelChanged();
                target.add(new Component[]{SchemaInfoPage.this.tablePanel});
                target.add(new Component[]{SchemaInfoPage.this});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener ajaxCall = new AjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        CharSequence message = new ParamResourceModel("confirmRemove", (Component)SchemaInfoPage.this, new Object[0]).getString();
                        message = JavaScriptUtils.escapeQuotes((CharSequence)message);
                        return "return confirm('" + message + "');";
                    }
                };
                attributes.getAjaxCallListeners().add(ajaxCall);
            }
        };
    }
}

