/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web.schema;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.wicket.Component;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaDAOListener;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAOImpl;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.featurestemplating.configuration.schema.SchemaTypeTemplateDAOListener;
import org.geoserver.featurestemplating.web.schema.SchemaRuleConfigurationPanel;
import org.geoserver.featurestemplating.web.schema.SchemaRulesTablePanel;
import org.geoserver.web.publish.PublishedEditTabPanel;

public class SchemaRulesTabPanel
extends PublishedEditTabPanel<LayerInfo> {
    public SchemaRuleConfigurationPanel configurationPanel;

    public SchemaRulesTabPanel(String id, IModel<LayerInfo> model) {
        super(id, model);
        LayerInfo li = (LayerInfo)model.getObject();
        ResourceInfo ri = li.getResource();
        if (!(ri instanceof FeatureTypeInfo)) {
            this.configurationPanel.setEnabled(false);
        }
        SchemaInfoDAOImpl infoDao = SchemaInfoDAO.get();
        SchemaTypeTemplateDAOListener listener = new SchemaTypeTemplateDAOListener((FeatureTypeInfo)ri);
        infoDao.addSchemaListener((SchemaDAOListener)listener);
        PropertyModel resource = new PropertyModel(model, "resource");
        PropertyModel metadata = new PropertyModel((Object)resource, "metadata");
        SchemaRulesTablePanel tablePanel = new SchemaRulesTablePanel("schemaRules", (IModel<MetadataMap>)metadata);
        tablePanel.setOutputMarkupId(true);
        this.add(new Component[]{tablePanel});
        this.configurationPanel = new SchemaRuleConfigurationPanel("schemaRuleConfiguration", (CompoundPropertyModel<SchemaRule>)new CompoundPropertyModel((Object)new SchemaRule()), false, li);
        this.configurationPanel.setTemplateRuleTablePanel(tablePanel);
        this.configurationPanel.setOutputMarkupId(true);
        tablePanel.setConfigurationPanel(this.configurationPanel);
        this.add(new Component[]{this.configurationPanel});
    }

    public void beforeSave() {
        super.beforeSave();
    }

    public void save() throws IOException {
        SchemaRule ruleModel = (SchemaRule)this.configurationPanel.schemaRuleModel.getObject();
        HashSet<SchemaRule> rules = new HashSet<SchemaRule>((Collection)this.configurationPanel.tablePanel.getModel().getObject());
        rules.add(ruleModel);
        this.configurationPanel.tablePanel.getModel().setObject(rules);
        super.save();
    }
}

