/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web.schema;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.featurestemplating.configuration.schema.SchemaLayerConfig;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.featurestemplating.web.schema.SchemaRuleConfigurationPanel;
import org.geoserver.featurestemplating.web.schema.SchemaRuleProvider;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class SchemaRulesTablePanel
extends Panel {
    private GeoServerTablePanel<SchemaRule> table;
    private AjaxLink<Object> remove;
    private SchemaRuleConfigurationPanel configurationPanel;
    private LiveCollectionModel<SchemaRule, Set<SchemaRule>> model;

    public SchemaRulesTablePanel(String id, IModel<MetadataMap> metadataModel) {
        super(id);
        MapModel mapModelLayerConf = new MapModel(metadataModel, "FEATURES_SCHEMA_LAYER_CONF");
        Object object = mapModelLayerConf.getObject();
        if (!(object instanceof SchemaLayerConfig)) {
            mapModelLayerConf.setObject((Object)new SchemaLayerConfig());
        }
        this.model = LiveCollectionModel.set((IModel)new PropertyModel((Object)mapModelLayerConf, "schemaRules"));
        SchemaRuleProvider dataProvider = new SchemaRuleProvider(this.model);
        this.table = new SchemaRuleTable("table", dataProvider, true);
        this.table.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.remove = new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                Set rules = (Set)SchemaRulesTablePanel.this.getModel().getObject();
                HashSet updated = new HashSet(rules);
                updated.removeAll(SchemaRulesTablePanel.this.table.getSelection());
                SchemaRulesTablePanel.this.getModel().setObject(updated);
                SchemaRulesTablePanel.this.modelChanged();
                SchemaRulesTablePanel.this.table.modelChanged();
                target.add(new Component[]{SchemaRulesTablePanel.this.table});
            }
        };
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.add(new Component[]{this.table});
    }

    public LiveCollectionModel<SchemaRule, Set<SchemaRule>> getModel() {
        return this.model;
    }

    public GeoServerTablePanel<SchemaRule> getTable() {
        return this.table;
    }

    public void setConfigurationPanel(SchemaRuleConfigurationPanel panel) {
        this.configurationPanel = panel;
    }

    public class SchemaRuleTable
    extends GeoServerTablePanel<SchemaRule> {
        public SchemaRuleTable(String id, GeoServerDataProvider<SchemaRule> dataProvider, boolean selectable) {
            super(id, dataProvider, selectable);
        }

        protected Component getComponentForProperty(String id, final IModel<SchemaRule> itemModel, GeoServerDataProvider.Property<SchemaRule> property) {
            if (property.equals(SchemaRuleProvider.PRIORITY)) {
                return new Label(id, SchemaRuleProvider.PRIORITY.getModel(itemModel));
            }
            if (property.equals(SchemaRuleProvider.NAME)) {
                return new SimpleAjaxLink<SchemaRule>(id, itemModel, SchemaRuleProvider.NAME.getModel(itemModel)){

                    protected void onClick(AjaxRequestTarget target) {
                        SchemaRule rule = (SchemaRule)itemModel.getObject();
                        SchemaRulesTablePanel.this.configurationPanel.theForm.getModel().setObject((Object)rule);
                        SchemaRulesTablePanel.this.configurationPanel.theForm.modelChanged();
                        String submitLabel = SchemaRulesTablePanel.this.configurationPanel.getSubmitLabelValue("update");
                        SchemaRulesTablePanel.this.configurationPanel.submitLabelModel.setObject((Serializable)((Object)submitLabel));
                        String panelLabel = SchemaRulesTablePanel.this.configurationPanel.getPanelLabelValue("update");
                        SchemaRulesTablePanel.this.configurationPanel.panelLabelModel.setObject((Serializable)((Object)panelLabel));
                        target.add(new Component[]{SchemaRulesTablePanel.this.configurationPanel.theForm});
                        target.add(new Component[]{SchemaRulesTablePanel.this.configurationPanel.submitLabel});
                        target.add(new Component[]{SchemaRulesTablePanel.this.configurationPanel.panelLabel});
                    }
                };
            }
            if (property.equals(SchemaRuleProvider.OUTPUT_FORMAT)) {
                return new Label(id, SchemaRuleProvider.OUTPUT_FORMAT.getModel(itemModel));
            }
            if (property.equals(SchemaRuleProvider.CQL_FILTER)) {
                return new Label(id, SchemaRuleProvider.CQL_FILTER.getModel(itemModel));
            }
            if (property.equals(SchemaRuleProvider.PROFILE_FILTER)) {
                return new Label(id, SchemaRuleProvider.PROFILE_FILTER.getModel(itemModel));
            }
            return null;
        }
    }
}

