/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.schemalessfeatures.mongodb.AbstractMongoDBOnlineTestSupport;
import org.geoserver.schemalessfeatures.mongodb.MongoTestSetup;
import org.geoserver.schemalessfeatures.mongodb.StationsTestSetup;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.URLs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMSSchemalessMongoTest
extends AbstractMongoDBOnlineTestSupport {
    protected static final String DATA_STORE_NAME = "stationsMongoWfs";
    private static MongoTestSetup testSetup;
    private static final String STYLE_ST = "stations";
    private static final String STYLE_ST_RT = "stationsRT";
    private static final String STYLE_ST_SORT_ASC = "stationsSortAsc";
    private static final String STYLE_ST_SORT_DESC = "stationsSortDesc";
    private static final String STYLE_NULLABLE_FIELD = "stationsFilterOnNullableField";
    private XpathEngine xpath;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.xpath = XMLUnit.newXpathEngine();
        Catalog cat = this.getCatalog();
        DataStoreInfo storeInfo = cat.getDataStoreByName(DATA_STORE_NAME);
        if (storeInfo == null) {
            WorkspaceInfo wi = cat.getDefaultWorkspace();
            storeInfo = this.addMongoSchemalessStore(wi, DATA_STORE_NAME);
            this.addMongoSchemalessLayer(wi, storeInfo, "geoJSONStations");
            LayerInfo li = cat.getLayerByName((Name)new NameImpl(wi.getName(), "geoJSONStations"));
            StyleInfo st = cat.getStyleByName(STYLE_ST);
            li.setDefaultStyle(st);
            StyleInfo stRT = cat.getStyleByName(STYLE_ST_RT);
            li.getStyles().add(stRT);
            StyleInfo stSortAsc = cat.getStyleByName(STYLE_ST_SORT_ASC);
            li.getStyles().add(stSortAsc);
            StyleInfo stSortDesc = cat.getStyleByName(STYLE_ST_SORT_DESC);
            li.getStyles().add(stSortDesc);
            StyleInfo stNullableField = cat.getStyleByName(STYLE_NULLABLE_FIELD);
            li.getStyles().add(stNullableField);
            cat.save(li);
        }
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle(STYLE_ST, "./test-data/stations/styles/stations.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_ST_RT, "./test-data/stations/styles/stations_with_RT.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_ST_SORT_ASC, "./test-data/stations/styles/stations_with_sort_by_asc.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_ST_SORT_DESC, "./test-data/stations/styles/stations_with_sort_by_desc.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_NULLABLE_FIELD, "./test-data/stations/styles/stationsFilterOnNullableField.sld", ((Object)((Object)this)).getClass(), catalog);
    }

    @Override
    protected MongoTestSetup createTestSetups() {
        testSetup = new StationsTestSetup(this.databaseName);
        return testSetup;
    }

    @AfterClass
    public static void tearDown() {
        if (testSetup != null) {
            testSetup.tearDown();
        }
    }

    @Test
    public void testStationsWmsGetMap() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES&LAYERS=gs:geoJSONStations&SRS=EPSG:4326&WIDTH=349&HEIGHT=768&BBOX=96.251220703125,-57.81005859375,103.919677734375,-40.93505859375");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-style-result.png")), (RenderedImage)image, (int)600);
    }

    @Test
    public void testStationsWmsGetMapWithSortByDesc() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES=stationsSortDesc&LAYERS=gs:geoJSONStations&SRS=EPSG:4326&WIDTH=349&HEIGHT=768&BBOX=96.251220703125,-57.81005859375,103.919677734375,-40.93505859375");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-style-sort.png")), (RenderedImage)image, (int)240);
    }

    @Test
    public void testStationsWmsGetMapWithSortByAsc() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES=stationsSortAsc&LAYERS=gs:geoJSONStations&SRS=EPSG:4326&WIDTH=349&HEIGHT=768&BBOX=96.251220703125,-57.81005859375,103.919677734375,-40.93505859375");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-style-sort.png")), (RenderedImage)image, (int)240);
    }

    @Test
    @Ignore
    public void testStationsWmsGetMapWithRendering() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES=stationsRT&LAYERS=gs:geoJSONStations&SRS=EPSG:4326&WIDTH=576&HEIGHT=768&BBOX=5,-60,110,80");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-rt.png")), (RenderedImage)image, (int)240);
    }

    @Test
    public void testStationsWmsGetFeatureInfo() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=gs:geoJSONStations&STYLES=point&LAYERS=gs:geoJSONStations&INFO_FORMAT=application/json&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=91.23046875,-58.623046874999986,108.984375,-40.869140624999986");
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            this.checkStationFeature(feature);
        }
    }

    @Test
    public void testStationsWmsGetMapStyleNullableField() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES=stationsFilterOnNullableField&LAYERS=gs:geoJSONStations&SRS=EPSG:4326&WIDTH=349&HEIGHT=768&BBOX=96.251220703125,-57.81005859375,103.919677734375,-40.93505859375");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-nullable-result.png")), (RenderedImage)image, (int)240);
    }

    private void checkStationFeature(JSONObject station) {
        JSONObject properties = station.getJSONObject("properties");
        JSONObject geometry = station.getJSONObject("geometry");
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.has("type"));
        Assert.assertTrue((boolean)geometry.has("coordinates"));
        Assert.assertNotNull((Object)properties.get("id"));
        Assert.assertNotNull((Object)properties.get("name"));
        Assert.assertNotNull((Object)properties.get("numericValue"));
        JSONObject contact = properties.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)1L, (long)contact.size());
        JSONArray measurements = properties.getJSONArray("measurements");
        Assert.assertNotNull((Object)measurements);
        Assert.assertTrue((measurements.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSchemalessLayerInCapabilities() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetCapabilities&service=WMS&version=1.1.1");
        Assert.assertTrue((this.xpath.getMatchingNodes("//Layer/Name[contains(.,geoJSONStations)]", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSchemalessLayerInCapabilities13() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetCapabilities&service=WMS&version=1.3.0");
        Assert.assertTrue((this.xpath.getMatchingNodes("//wms:Layer/wms:Name[contains(.,geoJSONStations)]", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLayerWithNameDifferentFromMongoCollection() throws Exception {
        String layerRename = "StationsRenamed";
        Catalog cat = this.getCatalog();
        FeatureTypeInfo fti = cat.getFeatureTypeByName("gs", "geoJSONStations");
        fti.setName(layerRename);
        cat.save((ResourceInfo)fti);
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES&LAYERS=gs:StationsRenamed&SRS=EPSG:4326&WIDTH=349&HEIGHT=768&BBOX=96.251220703125,-57.81005859375,103.919677734375,-40.93505859375");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
    }

    @Test
    public void testStationsWmsGetFeatureInfoHTMLAllowed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=gs:geoJSONStations&STYLES&LAYERS=gs:geoJSONStations&INFO_FORMAT=text/html&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=91.23046875,-58.623046874999986,108.984375,-40.869140624999986");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testStationsWmsGetFeatureInfoXMLNotAllowed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=gs:geoJSONStations&STYLES&LAYERS=gs:geoJSONStations&INFO_FORMAT=text/xml&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=91.23046875,-58.623046874999986,108.984375,-40.869140624999986");
        String respMsg = response.getContentAsString();
        Assert.assertTrue((boolean)respMsg.contains("Schemaless support for GetFeatureInfo is not available for text/xml"));
    }

    @Test
    public void testDispatcherCallbackNotBlockingNonSchemaless() throws Exception {
        String layerName = this.getLayerId(MockData.BRIDGES);
        String base2d = "wms?version=1.1.1&format=png&info_format=text/xml&request=GetFeatureInfo&layers=" + layerName + "&query_layers=" + layerName + "&styles=stacker&bbox=-1,-1,1,1&srs=EPSG:4326&feature_count=10";
        MockHttpServletResponse response = this.getAsServletResponse(base2d + "&width=100&height=100&x=50&y=50");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testStationsWmsGetMapReproject() throws Exception {
        MockHttpServletResponse result = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&STYLES&LAYERS=gs:geoJSONStations&SRS=EPSG:3857&WIDTH=349&HEIGHT=768&BBOX=10714636.876902865,-7927522.173199544,11568285.608791715,-5002767.535052578");
        Assert.assertEquals((long)result.getStatus(), (long)200L);
        Assert.assertEquals((Object)result.getContentType(), (Object)"image/png");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.getBinary(result)));
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("wms-results/stations-reprojected.png")), (RenderedImage)image, (int)600);
    }
}

