/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.schemalessfeatures.mongodb.MongoTestSetup;
import org.geoserver.schemalessfeatures.mongodb.data.MongoSchemalessDataStoreFactory;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.test.FixtureUtilities;
import org.junit.Before;

public abstract class AbstractMongoDBOnlineTestSupport
extends GeoServerSystemTestSupport {
    protected Properties fixture;
    private String fixtureId = "schemaless-mongo";
    protected static final String DB_PREFIX = "mock";
    protected String databaseName = "mock" + ((Object)((Object)this)).getClass().getSimpleName();

    @Before
    public void setUp() throws Exception {
        this.fixture = this.getFixture();
        MongoTestSetup testSetup = this.createTestSetups();
        testSetup.setFixture(this.fixture);
        testSetup.setUp();
    }

    protected Properties getFixture() {
        File exFixtureFile;
        File fixtureFile = FixtureUtilities.getFixtureFile((File)this.getFixtureDirectory(), (String)this.fixtureId);
        if (fixtureFile.exists()) {
            return FixtureUtilities.loadProperties((File)fixtureFile);
        }
        Properties exampleFixture = this.createExampleFixture();
        if (exampleFixture != null && !(exFixtureFile = new File(fixtureFile.getAbsolutePath() + ".example")).exists()) {
            this.createExampleFixture(exFixtureFile, exampleFixture);
        }
        FixtureUtilities.printSkipNotice((String)this.fixtureId, (File)fixtureFile);
        return null;
    }

    private void createExampleFixture(File exFixtureFile, Properties exampleFixture) {
        FileOutputStream fout = null;
        try {
            exFixtureFile.getParentFile().mkdirs();
            exFixtureFile.createNewFile();
            fout = new FileOutputStream(exFixtureFile);
            exampleFixture.store(fout, "This is an example fixture. Update the values and remove the .example suffix to enable the test");
            fout.flush();
            fout.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    File getFixtureDirectory() {
        return new File(System.getProperty("user.home") + File.separator + ".geoserver");
    }

    Properties createExampleFixture() {
        Properties fixture = new Properties();
        fixture.put("mongo.connectionString", "examples= mongodb://localhost:27017, mongodb://username:password@localhost:27017");
        return fixture;
    }

    protected abstract MongoTestSetup createTestSetups();

    protected DataStoreInfo addMongoSchemalessStore(WorkspaceInfo ws, String storeName) {
        Catalog catalog = this.getCatalog();
        DataStoreInfo store = catalog.getDataStoreByName(storeName);
        if (store == null) {
            store = catalog.getFactory().createDataStore();
            store.setName(storeName);
            store.setWorkspace(ws);
            store.setEnabled(true);
            String connectionString = this.fixture.getProperty("mongo.connectionString") + "/" + this.databaseName;
            NamespaceInfo namespace = catalog.getNamespaceByPrefix(ws.getName());
            store.getConnectionParameters().put(MongoSchemalessDataStoreFactory.CONNECTION_STRING.key, connectionString);
            store.getConnectionParameters().put(MongoSchemalessDataStoreFactory.NAMESPACE.key, namespace.getURI());
            store.getConnectionParameters().put("dbtype", "MongoDB Schemaless");
            store.setType(new MongoSchemalessDataStoreFactory().getDisplayName());
            catalog.add((StoreInfo)store);
        }
        return catalog.getDataStoreByName(ws.getName(), storeName);
    }

    protected void addMongoSchemalessLayer(WorkspaceInfo ws, DataStoreInfo store, String typeName) throws IOException {
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setWorkspace(ws);
        builder.setStore((StoreInfo)store);
        DataAccess dataAccess = store.getDataStore(null);
        HashMap featureTypesByNativeName = new HashMap();
        FeatureSource fs = dataAccess.getFeatureSource((Name)new NameImpl(ws.getName(), typeName));
        FeatureTypeInfo ftinfo = (FeatureTypeInfo)featureTypesByNativeName.get(typeName);
        if (ftinfo == null) {
            ftinfo = builder.buildFeatureType(fs);
            builder.lookupSRS(ftinfo, true);
            builder.setupBounds(ftinfo, fs);
        }
        ReferencedEnvelope bounds = fs.getBounds();
        ftinfo.setNativeBoundingBox(bounds);
        if (ftinfo.getId() == null) {
            catalog.validate((ResourceInfo)ftinfo, true).throwIfInvalid();
            catalog.add((ResourceInfo)ftinfo);
        }
        LayerInfo layer = builder.buildLayer(ftinfo);
        boolean valid = true;
        try {
            if (!catalog.validate(layer, true).isValid()) {
                valid = false;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        layer.setEnabled(valid);
        catalog.add(layer);
    }
}

