/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Properties;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class MongoTestSetup {
    protected Properties fixture = null;
    protected MongoClient client;
    protected MongoDatabase database;
    protected MongoCollection<Document> collection;

    public void setUp() throws Exception {
        this.setUpData();
    }

    protected abstract void setUpData() throws Exception;

    public abstract void tearDown();

    public void setFixture(Properties fixture) {
        this.fixture = fixture;
    }

    protected void insertJson(String json) {
        Document document = Document.parse((String)json);
        this.collection.insertOne((Object)document);
    }

    protected void addGeometryIndex() {
        BasicDBObject indexObject = new BasicDBObject();
        indexObject.put((Object)"geometry", (Object)"2dsphere");
        this.collection.createIndex((Bson)indexObject);
    }
}

