/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb.mappers;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.geoserver.schemalessfeatures.SchemalessFeatureMapper;
import org.geoserver.schemalessfeatures.builders.DynamicComplexTypeBuilder;
import org.geoserver.schemalessfeatures.builders.DynamicComplexTypeFactory;
import org.geoserver.schemalessfeatures.mongodb.MongoSchemalessUtils;
import org.geoserver.schemalessfeatures.type.DynamicComplexType;
import org.geoserver.schemalessfeatures.type.DynamicFeatureType;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;

public class SchemalessMongoToComplexMapper
extends SchemalessFeatureMapper<DBObject> {
    private MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();
    private DynamicFeatureType type;
    private final CoordinateReferenceSystem crs;
    private final boolean reproject;
    private MathTransform transform = null;

    public SchemalessMongoToComplexMapper(DynamicFeatureType type, CoordinateReferenceSystem crs) {
        super(new AttributeBuilder((FeatureFactory)new ValidatingFeatureFactoryImpl()), new DynamicComplexTypeBuilder(new DynamicComplexTypeFactory()));
        this.type = type;
        this.crs = crs;
        boolean bl = this.reproject = crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84);
        if (this.reproject) {
            try {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Feature buildFeature(DBObject rootDBO) {
        this.attributeBuilder.init();
        List<Property> attributes = this.getNestedAttributes(rootDBO, (DynamicComplexType)this.type);
        ComplexFeatureBuilder featureBuilder = new ComplexFeatureBuilder((FeatureType)this.type);
        GeometryAttribute geometryAttribute = null;
        for (Property p : attributes) {
            if (p instanceof GeometryAttribute) {
                GeometryAttribute geom = (GeometryAttribute)p;
                this.handleGeometryReprojection(geom);
                if (!p.getName().equals((Object)this.type.getGeometryDescriptor().getName())) continue;
                geometryAttribute = geom;
                featureBuilder.append(p.getName(), (Property)geometryAttribute);
                continue;
            }
            featureBuilder.append(p.getName(), p);
        }
        Feature f = featureBuilder.buildFeature(rootDBO.get("_id").toString());
        f.setDefaultGeometryProperty(geometryAttribute);
        return f;
    }

    private void handleGeometryReprojection(GeometryAttribute geom) {
        if (this.crs == null) {
            return;
        }
        Geometry geomValue = (Geometry)geom.getValue();
        if (this.reproject) {
            try {
                geomValue = JTS.transform((Geometry)geomValue, (MathTransform)this.transform);
                JTS.setCRS((Geometry)geomValue, (CoordinateReferenceSystem)this.crs);
                geom.setValue((Object)geomValue);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<Property> getNestedAttributes(DBObject rootDBO, DynamicComplexType parentType) {
        Set keys = rootDBO.keySet();
        String namespaceURI = this.type.getName().getNamespaceURI();
        ArrayList<Property> attributes = new ArrayList<Property>();
        for (String key : keys) {
            Object value = rootDBO.get(key);
            if (value == null) {
                attributes.add((Property)this.buildNullAttribute(namespaceURI, key, parentType));
                continue;
            }
            if (value instanceof BasicDBList) {
                BasicDBList list = (BasicDBList)value;
                attributes.addAll(this.buildComplexAttributesUnbounded(namespaceURI, key, list, parentType));
                continue;
            }
            if (value instanceof DBObject) {
                DBObject dbObj = (DBObject)value;
                if (MongoSchemalessUtils.isGeometry(dbObj)) {
                    Geometry geom = this.geomBuilder.toGeometry(dbObj);
                    GeometryAttribute geometryAttribute = this.buildGeometryAttribute(geom, namespaceURI, key, parentType);
                    attributes.add((Property)geometryAttribute);
                    continue;
                }
                attributes.add((Property)this.buildComplexAttribute(namespaceURI, key, (DBObject)value, parentType, false));
                continue;
            }
            attributes.add((Property)this.buildSimpleAttribute(namespaceURI, key, value, parentType));
        }
        return attributes;
    }

    private Attribute buildComplexAttribute(String namespaceURI, String attrName, DBObject dbobject, DynamicComplexType parentType, boolean isCollection) {
        boolean notAComplexType;
        PropertyDescriptor descriptorProperty = parentType.getDescriptor((Name)new NameImpl(namespaceURI, attrName));
        boolean bl = notAComplexType = descriptorProperty != null && !(descriptorProperty.getType() instanceof DynamicComplexType);
        if (descriptorProperty == null || notAComplexType) {
            descriptorProperty = this.buildFullyObjectPropertyModelDescriptor(parentType, namespaceURI, attrName, isCollection);
        }
        ComplexType complexTypeProperty = (ComplexType)descriptorProperty.getType();
        PropertyDescriptor nestedFeatureDescriptor = this.extractFeatureDescriptor(descriptorProperty);
        DynamicComplexType nestedFeatureType = (DynamicComplexType)nestedFeatureDescriptor.getType();
        ComplexFeatureBuilder featureBuilder = new ComplexFeatureBuilder((AttributeDescriptor)nestedFeatureDescriptor);
        List<Property> attributes = this.getNestedAttributes(dbobject, nestedFeatureType);
        for (Property p : attributes) {
            featureBuilder.append(p.getName(), p);
        }
        Feature f = featureBuilder.buildFeature(null);
        ComplexAttribute propertyAttribute = this.attributeBuilder.createComplexAttribute(Arrays.asList(f), complexTypeProperty, (AttributeDescriptor)descriptorProperty, null);
        return propertyAttribute;
    }

    private List<Property> buildComplexAttributesUnbounded(String namespaceURI, String attrName, BasicDBList value, DynamicComplexType parentType) {
        ArrayList<Property> attributes = new ArrayList<Property>();
        for (int i = 0; i < value.size(); ++i) {
            Attribute attribute;
            Object obj = value.get(i);
            if (obj instanceof DBObject) {
                attribute = this.buildComplexAttribute(namespaceURI, attrName, (DBObject)obj, parentType, true);
                attributes.add((Property)attribute);
                continue;
            }
            if (obj != null) {
                attribute = this.buildSimpleAttribute(namespaceURI, attrName, obj, parentType, true);
                attributes.add((Property)attribute);
                continue;
            }
            if (obj != null) continue;
            attribute = this.buildNullAttribute(namespaceURI, attrName, parentType);
            attributes.add((Property)attribute);
        }
        return attributes;
    }

    private GeometryAttribute buildGeometryAttribute(Geometry geom, String namespaceURI, String name, DynamicComplexType parentType) {
        AttributeDescriptor descriptor = (AttributeDescriptor)parentType.getDescriptor((Name)new NameImpl(namespaceURI, name));
        if (descriptor == null) {
            this.typeBuilder.binding(geom.getClass()).name(name).namespaceURI(namespaceURI).maxOccurs(1).minOccurs(0);
            GeometryType attrType = this.typeBuilder.buildGeometryType();
            descriptor = this.typeBuilder.buildDescriptor(attrType.getName(), attrType);
            GeometryDescriptor geometryDescriptor = this.type.getGeometryDescriptor();
            if (geometryDescriptor == null) {
                this.type.setGeometryDescriptor((GeometryDescriptor)descriptor);
                this.type.addPropertyDescriptor((PropertyDescriptor)descriptor);
            } else {
                parentType.addPropertyDescriptor((PropertyDescriptor)descriptor);
            }
        }
        this.attributeBuilder.setDescriptor(descriptor);
        return (GeometryAttribute)this.attributeBuilder.buildSimple(null, (Object)geom);
    }

    private PropertyDescriptor extractFeatureDescriptor(PropertyDescriptor descriptorProperty) {
        if (descriptorProperty == null) {
            return null;
        }
        ComplexType typeFeature = (ComplexType)descriptorProperty.getType();
        return (PropertyDescriptor)typeFeature.getDescriptors().iterator().next();
    }
}

