/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.schemalessfeatures.mongodb.AbstractMongoDBOnlineTestSupport;
import org.geoserver.schemalessfeatures.mongodb.MongoTestSetup;
import org.geoserver.schemalessfeatures.mongodb.StationsTestSetup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class WFSSchemalessMongoTest
extends AbstractMongoDBOnlineTestSupport {
    private static final String DATA_STORE_NAME = "stationsMongoWfs";
    private static MongoTestSetup testSetup;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Catalog cat = this.getCatalog();
        DataStoreInfo storeInfo = cat.getDataStoreByName(DATA_STORE_NAME);
        if (storeInfo == null) {
            WorkspaceInfo wi = cat.getDefaultWorkspace();
            storeInfo = this.addMongoSchemalessStore(wi, DATA_STORE_NAME);
            this.addMongoSchemalessLayer(wi, storeInfo, "geoJSONStations");
        }
    }

    @Override
    protected MongoTestSetup createTestSetups() {
        StationsTestSetup setup = new StationsTestSetup(this.databaseName);
        testSetup = setup;
        return setup;
    }

    @AfterClass
    public static void tearDown() {
        if (testSetup != null) {
            testSetup.tearDown();
        }
    }

    @Test
    public void testGetStationFeatures() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)12L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            WFSSchemalessMongoTest.checkStationFeature(feature);
        }
    }

    @Test
    public void testGetStationFeaturesWithFilter() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=measurements.values.value > 2000");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"58e5889ce4b02461ad5af091", (Object)features.getJSONObject(0).getString("id"));
    }

    @Test
    public void testGetStationFeaturesWithFilterPOST() throws Exception {
        String postContent = this.readResourceContent("./test-data/stations/query/postQuery.xml");
        JSON json = this.postAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json", postContent, "application/json");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)features.size());
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            ids.add(feature.getString("id"));
        }
        Assert.assertTrue((boolean)ids.contains("58e5889ce4b02461ad5af080"));
        Assert.assertTrue((boolean)ids.contains("58e5889ce4b02461ad5af084"));
    }

    @Test
    public void testGetFeatureRequestUnsupportedFormatReturnError() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations");
        String respStr = resp.getContentAsString();
        Assert.assertTrue((boolean)respStr.contains("Schemaless support for GetFeature is not available for text/xml"));
    }

    @Test
    public void testGetStationFeaturesWithFilterNull() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=nullableField IS NULL");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
    }

    @Test
    public void testGetStationFeaturesWithFilterNull2() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=anotherNullableField IS NULL");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)10L, (long)features.size());
    }

    @Test
    public void testGetStationFeaturesWithFilterNotNull() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=anotherNullableField IS NOT NULL");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)features.size());
    }

    @Test
    public void testGetStationFeaturesWithFilterNotNull2() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=anotherNullableField.value IS NOT NULL");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
    }

    static void checkStationFeature(JSONObject station) {
        JSONObject properties = station.getJSONObject("properties");
        JSONObject geometry = station.getJSONObject("geometry");
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.has("type"));
        Assert.assertTrue((boolean)geometry.has("coordinates"));
        Assert.assertNotNull((Object)properties.get("id"));
        Assert.assertNotNull((Object)properties.get("name"));
        Assert.assertNotNull((Object)properties.get("numericValue"));
        JSONObject contact = properties.getJSONObject("contact");
        Assert.assertNotNull((Object)contact);
        WFSSchemalessMongoTest.assertSkippedGeoJSONProperties(contact);
        Assert.assertEquals((long)1L, (long)contact.size());
        JSONArray measurements = properties.getJSONArray("measurements");
        Assert.assertNotNull((Object)measurements);
        Assert.assertTrue((measurements.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < measurements.size(); ++i) {
            JSONObject measurement = measurements.getJSONObject(i);
            WFSSchemalessMongoTest.assertSkippedGeoJSONProperties(measurement);
        }
    }

    private static void assertSkippedGeoJSONProperties(JSONObject object) {
        Assert.assertFalse((boolean)object.has("properties"));
        Assert.assertFalse((boolean)object.has("geometry"));
        Assert.assertFalse((boolean)object.has("id"));
        Assert.assertFalse((boolean)object.has("type"));
    }

    private String readResourceContent(String resourcePath) {
        String string;
        block8: {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
                string = new String(output.toByteArray());
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Error reading resource '%s' content.", resourcePath), exception);
                }
            }
            input.close();
        }
        return string;
    }

    @Ignore
    @Test
    public void testGetStationFeaturesWithFilterPOSTNotReturnEmptyCollection() throws Exception {
        String postContent = this.readResourceContent("./test-data/stations/query/postQueryTimeStamp.xml");
        JSON json = this.postAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json", postContent, "application/json");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)9L, (long)features.size());
    }

    @Test
    public void testGetStationFeaturesSameAttributesDifferentTypes() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&outputFormat=application/json&cql_filter=name='station 12' OR name='station 2'");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            JSONObject props = feature.getJSONObject("properties");
            String name = props.getString("name");
            Object object = props.get("numericValue");
            if (name.equals("station 2")) {
                Assert.assertEquals((Object)26, (Object)object);
            } else {
                Assert.assertEquals((Object)"43.0", (Object)object);
            }
            WFSSchemalessMongoTest.checkStationFeature(feature);
        }
    }

    @Test
    public void testGetStationFeaturesWithReprojection() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&srsName=EPSG:3857&outputFormat=application/json&cql_filter=measurements.values.value > 2000");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"58e5889ce4b02461ad5af091", (Object)features.getJSONObject(0).getString("id"));
        JSONArray coordinatesJsonArray = features.getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates");
        Assert.assertEquals((double)1113194.9, (double)coordinatesJsonArray.getDouble(0), (double)1.0E-4);
        Assert.assertEquals((double)-1345708.4, (double)coordinatesJsonArray.getDouble(1), (double)1.0E-4);
    }

    @Test
    public void testGetStationFeaturesWithGeometryFilter() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&srsName=EPSG:3857&outputFormat=application/json&cql_filter=measurements.values.value > 2000 and BBOX(geometry, 1113194, -1345709, 1113195, -1345708, 'EPSG:3857')");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"58e5889ce4b02461ad5af091", (Object)features.getJSONObject(0).getString("id"));
        JSONArray coordinatesJsonArray = features.getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates");
        Assert.assertEquals((double)1113194.9, (double)coordinatesJsonArray.getDouble(0), (double)1.0E-4);
        Assert.assertEquals((double)-1345708.4, (double)coordinatesJsonArray.getDouble(1), (double)1.0E-4);
    }

    @Test
    public void testGetStationFeaturesWithGeometryFilterAndReprojection() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gs:geoJSONStations&srsName=EPSG:3857&outputFormat=application/json&cql_filter=measurements.values.value > 2000 and BBOX(geometry, 9, -13, 11, -11, 'EPSG:4326')");
        JSONObject jsonObject = (JSONObject)json;
        JSONArray features = jsonObject.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"58e5889ce4b02461ad5af091", (Object)features.getJSONObject(0).getString("id"));
        JSONArray coordinatesJsonArray = features.getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates");
        Assert.assertEquals((double)1113194.9, (double)coordinatesJsonArray.getDouble(0), (double)1.0E-4);
        Assert.assertEquals((double)-1345708.4, (double)coordinatesJsonArray.getDouble(1), (double)1.0E-4);
    }
}

