/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb.data;

import com.mongodb.ConnectionString;
import com.mongodb.DBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geoserver.schemalessfeatures.data.ComplexContentDataAccess;
import org.geoserver.schemalessfeatures.mongodb.data.MongoSchemalessFeatureSource;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.FilterCapabilities;

public class MongoComplexContentDataAccess
extends ComplexContentDataAccess {
    private MongoDatabase database;
    private MongoClient client;

    public MongoComplexContentDataAccess(String connectionString) {
        ConnectionString connection = this.getConnectionString(connectionString);
        this.client = this.createMongoClient(connection);
        this.database = this.createMongoDatabase(connection.getDatabase());
    }

    protected List<Name> createTypeNames() {
        return this.getCollectionNames().stream().map(s -> this.name((String)s)).collect(Collectors.toList());
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        if (!this.getCollectionNames().contains(typeName.getLocalPart())) {
            throw new IOException("Type with name " + typeName.getLocalPart() + " not found");
        }
        MongoCollection collection = this.database.getCollection(typeName.getLocalPart(), DBObject.class);
        return new MongoSchemalessFeatureSource(typeName, (MongoCollection<DBObject>)collection, this);
    }

    private final ConnectionString getConnectionString(String dataStoreURI) {
        if (dataStoreURI == null) {
            throw new IllegalArgumentException("ConnectionString cannot be null");
        }
        if (!dataStoreURI.startsWith("mongodb://")) {
            throw new IllegalArgumentException("incorrect scheme for URI, expected to begin with \"mongodb://\", found URI of \"" + dataStoreURI + "\"");
        }
        ConnectionString connectionString = new ConnectionString(dataStoreURI);
        if (connectionString == null) {
            throw new RuntimeException("unable to obtain a MongoDB connectionString from URI " + dataStoreURI);
        }
        return connectionString;
    }

    private final MongoClient createMongoClient(ConnectionString connectionString) {
        try {
            return MongoClients.create((ConnectionString)connectionString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown mongodb host(s): " + connectionString.toString(), e);
        }
    }

    private final MongoDatabase createMongoDatabase(String databaseName) {
        MongoDatabase database = null;
        if (this.client != null && (database = this.client.getDatabase(databaseName)) == null) {
            this.client.close();
            throw new IllegalArgumentException("Unknown mongodb database, \"" + databaseName + "\"");
        }
        return database;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(PropertyIsLike.class);
        capabilities.addType(BBOX.class);
        capabilities.addType(Intersects.class);
        capabilities.addType(Within.class);
        capabilities.addType(DWithin.class);
        capabilities.addType(Id.class);
        return capabilities;
    }

    public void dispose() {
        this.client.close();
    }

    private Set<String> getCollectionNames() {
        LinkedHashSet<String> collectionNames = new LinkedHashSet<String>();
        this.database.listCollectionNames().forEach(n -> collectionNames.add((String)n));
        return collectionNames;
    }
}

