/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.DataUtilities;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ChangesetIndexProvider {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private static final Logger LOGGER = Logging.getLogger(ChangesetIndexProvider.class);
    public static final String INITIAL_STATE = "Initial";
    public static final String CHECKPOINT = "checkpoint";
    public static final String FOOTPRINT = "footprint";
    public static final String TIMESTAMP = "timestamp";
    private final DataStore checkpointIndex;

    public ChangesetIndexProvider(GeoServerDataDirectory dd, Catalog catalog) throws IOException {
        this.checkpointIndex = this.getCheckpointDataStore(dd);
        catalog.addListener((CatalogListener)new IndexCatalogListener());
    }

    @EventListener
    public void handleContextClosedEvent(ContextClosedEvent event) {
        this.checkpointIndex.dispose();
    }

    DataStore getCheckpointDataStore(GeoServerDataDirectory dd) throws IOException {
        Resource properties = dd.get(new String[]{"changeset-store.properties"});
        if (properties.getType() == Resource.Type.RESOURCE) {
            Properties p = new Properties();
            try (InputStream is = properties.in();){
                p.load(is);
            }
            return DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)p));
        }
        Resource changesetDir = dd.get(new String[]{"changeset"});
        if (changesetDir.getType() == Resource.Type.UNDEFINED) {
            changesetDir.dir();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbtype", "h2");
        params.put("database", new File(changesetDir.dir(), "index").getAbsolutePath());
        H2DataStoreFactory factory = new H2DataStoreFactory();
        return factory.createDataStore(params);
    }

    SimpleFeatureStore getStoreForCoverage(CoverageInfo ci, boolean createIfMissing) throws IOException {
        String typeName = ci.getId();
        if (!Arrays.asList(this.checkpointIndex.getTypeNames()).contains(typeName)) {
            if (createIfMissing) {
                SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                tb.add(CHECKPOINT, String.class);
                tb.add(TIMESTAMP, Timestamp.class);
                tb.add(FOOTPRINT, MultiPolygon.class, ci.getCRS());
                tb.setName(typeName);
                SimpleFeatureType type = tb.buildFeatureType();
                this.checkpointIndex.createSchema((FeatureType)type);
            } else {
                return null;
            }
        }
        return (SimpleFeatureStore)this.checkpointIndex.getFeatureSource(typeName);
    }

    void addCheckpoint(CoverageInfo ci, SimpleFeature feature) throws IOException {
        SimpleFeatureStore store = this.getStoreForCoverage(ci, true);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder((SimpleFeatureType)store.getSchema());
        String checkpoint = UUID.randomUUID().toString();
        fb.set(CHECKPOINT, (Object)checkpoint);
        fb.set(TIMESTAMP, (Object)new Timestamp(System.currentTimeMillis()));
        fb.set(FOOTPRINT, (Object)this.getFootprint(feature));
        SimpleFeature checkPointFeature = fb.buildFeature(null);
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)checkPointFeature));
    }

    private Geometry getFootprint(SimpleFeature feature) {
        Geometry featureGeometry = (Geometry)feature.getDefaultGeometry();
        if (featureGeometry instanceof MultiPolygon) {
            return featureGeometry;
        }
        if (featureGeometry instanceof Polygon) {
            return featureGeometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)featureGeometry});
        }
        throw new IllegalArgumentException("Unexpected geometry (type) from checkpoint: " + featureGeometry);
    }

    public SimpleFeatureCollection getModifiedAreas(CoverageInfo ci, String checkpoint, Filter spatialFilter) throws IOException {
        SimpleFeatureStore store = this.getStoreForCoverage(ci, false);
        if (store == null) {
            return null;
        }
        if (spatialFilter != null) {
            ReprojectingFilterVisitor visitor = new ReprojectingFilterVisitor(FF, store.getSchema());
            spatialFilter = (Filter)spatialFilter.accept((FilterVisitor)visitor, null);
        }
        if (INITIAL_STATE.equals(checkpoint)) {
            return store.getFeatures(spatialFilter);
        }
        Timestamp reference = this.getTimestampForCheckpoint(store, checkpoint);
        Query q = new Query();
        PropertyIsGreaterThan timeFilter = FF.greater((Expression)FF.property(TIMESTAMP), (Expression)FF.literal((Object)reference));
        if (spatialFilter != Filter.INCLUDE) {
            q.setFilter((Filter)FF.and((Filter)timeFilter, spatialFilter));
        } else {
            q.setFilter((Filter)timeFilter);
        }
        q.setSortBy(new SortBy[]{FF.sort(TIMESTAMP, SortOrder.ASCENDING)});
        return store.getFeatures(q);
    }

    private Timestamp getTimestampForCheckpoint(SimpleFeatureStore store, String checkpoint) throws IOException {
        SimpleFeatureCollection fc = store.getFeatures((Filter)FF.equals((Expression)FF.property(CHECKPOINT), (Expression)FF.literal((Object)checkpoint)));
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        if (first == null) {
            throw new InvalidParameterValueException("Checkpoint " + checkpoint + " cannot be found in change history");
        }
        return (Timestamp)first.getAttribute(TIMESTAMP);
    }

    public String getLatestCheckpoint(CoverageInfo ci) throws IOException {
        SimpleFeatureStore store = this.getStoreForCoverage(ci, false);
        if (store == null) {
            return INITIAL_STATE;
        }
        Query q = new Query(store.getName().getLocalPart());
        q.setSortBy(new SortBy[]{FF.sort(TIMESTAMP, SortOrder.DESCENDING)});
        q.setMaxFeatures(1);
        SimpleFeatureCollection fc = store.getFeatures(q);
        SimpleFeature latestCheckpoint = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        if (latestCheckpoint == null) {
            return INITIAL_STATE;
        }
        return (String)latestCheckpoint.getAttribute(CHECKPOINT);
    }

    private class IndexCatalogListener
    implements CatalogListener {
        private IndexCatalogListener() {
        }

        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
            if (event.getSource() instanceof CoverageInfo) {
                String typeName = event.getSource().getId();
                try {
                    if (Arrays.asList(ChangesetIndexProvider.this.checkpointIndex.getTypeNames()).contains(typeName)) {
                        ChangesetIndexProvider.this.checkpointIndex.removeSchema(typeName);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Coverage store " + event.getSource() + " has been removed, could not remove the corresponding index table named " + typeName, e);
                }
            }
        }

        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        }

        public void reloaded() {
        }
    }
}

