/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.changeset.ChangesetTest;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;

public class ChangesetCustomDBTest
extends ChangesetTest {
    public static final String CHANGESET_STORE_PROPERTIES = "changeset-store.properties";
    static File DATA_DIRECTORY;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File file = new File("./target/changeset-custom-db");
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        file.mkdir();
        DATA_DIRECTORY = testData.getDataDirectoryRoot();
        File configFile = new File(DATA_DIRECTORY, CHANGESET_STORE_PROPERTIES);
        try (InputStream is = ChangesetCustomDBTest.class.getResourceAsStream(CHANGESET_STORE_PROPERTIES);
             FileOutputStream os = new FileOutputStream(configFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void checkDatabaseUsage() throws Exception {
        MatcherAssert.assertThat((Object)DATA_DIRECTORY.listFiles().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
        Properties props = new Properties();
        try (InputStream is = ChangesetCustomDBTest.class.getResourceAsStream(CHANGESET_STORE_PROPERTIES);){
            props.load(is);
        }
        DataStore datastore = DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)props));
        try {
            MatcherAssert.assertThat((Object)datastore, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)datastore.getTypeNames().length, (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)datastore.getTypeNames()[0], (Matcher)Matchers.startsWith((String)"CoverageInfoImpl-"));
        }
        finally {
            datastore.dispose();
        }
    }
}

