/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class TilesExtensionsTest
extends OGCApiTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testApiExtension() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/tiles/v1/openapi", 200);
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        PathItem multiTile = (PathItem)api.getPaths().get((Object)"/collections/{collectionId}/map/{styleId}/tiles/{tileMatrixSetId}");
        MatcherAssert.assertThat((Object)multiTile, (Matcher)CoreMatchers.notNullValue());
        List parameterNames = multiTile.getGet().getParameters().stream().map(p -> p.get$ref()).collect(Collectors.toList());
        MatcherAssert.assertThat(parameterNames, (Matcher)CoreMatchers.hasItem((Object)"#/components/parameters/f-tile"));
        MatcherAssert.assertThat(parameterNames, (Matcher)CoreMatchers.hasItem((Object)"#/components/parameters/f-json-zip"));
        Map parameters = api.getComponents().getParameters();
        MatcherAssert.assertThat((Object)((Parameter)parameters.get("f-tile")), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((Parameter)parameters.get("f-json-zip")), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testMultiTileExtension() throws Exception {
    }
}

