/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.util.Arrays;
import org.geoserver.ogcapi.v1.changeset.TileIterator;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.junit.Assert;
import org.junit.Test;

public class TilesIteratorTest {
    static GridSet WGS84 = new DefaultGridsets(false, false).worldEpsg4326();
    static GridSet WEB_MERCATOR = new DefaultGridsets(false, false).worldEpsg3857();

    @Test
    public void iterateTwoLevelWholeWorldWgs84() {
        GridSubset subset = GridSubsetFactory.createGridSubSet((GridSet)WGS84, null, (Integer)0, (Integer)1);
        TileIterator iterator = new TileIterator(Arrays.asList(subset), 0, 1);
        this.assertIterator(iterator, {0L, 0L, 0L}, {1L, 0L, 0L}, {0L, 0L, 1L}, {1L, 0L, 1L}, {2L, 0L, 1L}, {3L, 0L, 1L}, {0L, 1L, 1L}, {1L, 1L, 1L}, {2L, 1L, 1L}, {3L, 1L, 1L});
    }

    @Test
    public void iterateTwoLevelWholeWorldWebMercator() {
        GridSubset subset = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, null, (Integer)0, (Integer)1);
        TileIterator iterator = new TileIterator(Arrays.asList(subset), 0, 1);
        this.assertIterator(iterator, {0L, 0L, 0L}, {0L, 0L, 1L}, {1L, 0L, 1L}, {0L, 1L, 1L}, {1L, 1L, 1L});
    }

    @Test
    public void iterateTwoLevelSubset00Wgs84() {
        GridSubset subset = GridSubsetFactory.createGridSubSet((GridSet)WGS84, (BoundingBox)new BoundingBox(-10.0, -10.0, 10.0, 10.0), (Integer)0, (Integer)1);
        TileIterator iterator = new TileIterator(Arrays.asList(subset), 0, 1);
        this.assertIterator(iterator, {0L, 0L, 0L}, {1L, 0L, 0L}, {1L, 0L, 1L}, {2L, 0L, 1L}, {1L, 1L, 1L}, {2L, 1L, 1L});
    }

    @Test
    public void iterateTwoLevelSubset00Wgs84DuplicateGridset() {
        GridSubset subset1 = GridSubsetFactory.createGridSubSet((GridSet)WGS84, (BoundingBox)new BoundingBox(-10.0, -10.0, 10.0, 10.0), (Integer)0, (Integer)1);
        GridSubset subset2 = new GridSubset(subset1);
        TileIterator iterator = new TileIterator(Arrays.asList(subset1, subset2), 0, 1);
        this.assertIterator(iterator, {0L, 0L, 0L}, {1L, 0L, 0L}, {1L, 0L, 1L}, {2L, 0L, 1L}, {1L, 1L, 1L}, {2L, 1L, 1L});
    }

    @Test
    public void iterateTwoLevelTwoSubsetsOverlapYWebMercator() {
        GridSubset subset1 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(-9900000.0, -1.49E7, 0.0, -5100000.0), (Integer)0, (Integer)3);
        GridSubset subset2 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(5100000.0, -9900000.0, 1.5E7, 0.0), (Integer)0, (Integer)3);
        TileIterator iterator = new TileIterator(Arrays.asList(subset1, subset2), 0, 3);
        this.assertIterator(iterator, {0L, 0L, 0L}, {0L, 0L, 1L}, {1L, 0L, 1L}, {1L, 0L, 2L}, {1L, 1L, 2L}, {2L, 1L, 2L}, {3L, 1L, 2L}, {2L, 1L, 3L}, {3L, 1L, 3L}, {2L, 2L, 3L}, {3L, 2L, 3L}, {5L, 2L, 3L}, {6L, 2L, 3L}, {5L, 3L, 3L}, {6L, 3L, 3L});
    }

    @Test
    public void iterateTwoLevelTwoSubsetsOverlapXWebMercator() {
        GridSubset subset1 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(-9900000.0, -1.49E7, 0.0, -5100000.0), (Integer)0, (Integer)3);
        GridSubset subset2 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(-5000000.0, 5100000.0, 5000000.0, 1.49E7), (Integer)0, (Integer)3);
        TileIterator iterator = new TileIterator(Arrays.asList(subset1, subset2), 0, 3);
        this.assertIterator(iterator, {0L, 0L, 0L}, {0L, 0L, 1L}, {0L, 1L, 1L}, {1L, 1L, 1L}, {1L, 0L, 2L}, {1L, 1L, 2L}, {1L, 2L, 2L}, {2L, 2L, 2L}, {1L, 3L, 2L}, {2L, 3L, 2L}, {2L, 1L, 3L}, {3L, 1L, 3L}, {2L, 2L, 3L}, {3L, 2L, 3L}, {3L, 5L, 3L}, {4L, 5L, 3L}, {3L, 6L, 3L}, {4L, 6L, 3L});
    }

    @Test
    public void iterateTwoLevelTwoSubsetsOverlapXYWebMercator() {
        GridSubset subset1 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(-9900000.0, -1.49E7, 0.0, -5100000.0), (Integer)0, (Integer)3);
        GridSubset subset2 = GridSubsetFactory.createGridSubSet((GridSet)WEB_MERCATOR, (BoundingBox)new BoundingBox(-5000000.0, -1.0E7, 5000000.0, 0.0), (Integer)0, (Integer)3);
        TileIterator iterator = new TileIterator(Arrays.asList(subset1, subset2), 0, 3);
        this.assertIterator(iterator, {0L, 0L, 0L}, {0L, 0L, 1L}, {1L, 0L, 1L}, {1L, 0L, 2L}, {1L, 1L, 2L}, {2L, 1L, 2L}, {2L, 1L, 3L}, {3L, 1L, 3L}, {2L, 2L, 3L}, {3L, 2L, 3L}, {4L, 2L, 3L}, {3L, 3L, 3L}, {4L, 3L, 3L});
    }

    @Test
    public void iterateOneLevelSouthEastCornerWgs84() {
        GridSubset subset = GridSubsetFactory.createGridSubSet((GridSet)WGS84, (BoundingBox)new BoundingBox(170.0, -90.0, 180.0, -80.0), (Integer)0, (Integer)3);
        TileIterator iterator = new TileIterator(Arrays.asList(subset), 2, 3);
        this.assertIterator(iterator, {7L, 0L, 2L}, {15L, 0L, 3L});
    }

    @Test
    public void iterateOneLevelNorthEastCornerWgs84() {
        GridSubset subset = GridSubsetFactory.createGridSubSet((GridSet)WGS84, (BoundingBox)new BoundingBox(170.0, 80.0, 180.0, 90.0), (Integer)0, (Integer)3);
        TileIterator iterator = new TileIterator(Arrays.asList(subset), 2, 3);
        this.assertIterator(iterator, {7L, 3L, 2L}, {15L, 7L, 3L});
    }

    private void assertIterator(TileIterator iterator, long[] ... positions) {
        if (positions != null) {
            for (long[] position : positions) {
                Assert.assertTrue((String)("Was expecting " + Arrays.toString(position) + " but found no more elements"), (boolean)iterator.hasNext());
                long[] next = iterator.next();
                Assert.assertArrayEquals((String)("Was expecting " + Arrays.toString(position) + " but found " + Arrays.toString(next)), (long[])position, (long[])next);
            }
        }
        Assert.assertFalse((String)"Shoud have reached the end but iterator still has more positions", (boolean)iterator.hasNext());
    }
}

