/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BoundsAndCRS {
    static final Logger LOGGER = Logging.getLogger(BoundsAndCRS.class);
    ReferencedEnvelope envelope;

    public BoundsAndCRS(ReferencedEnvelope envelope) {
        this.envelope = envelope;
    }

    public double[] getBbox() {
        return new double[]{this.envelope.getMinX(), this.envelope.getMinY(), this.envelope.getMaxX(), this.envelope.getMaxY()};
    }

    public String getCrs() {
        CoordinateReferenceSystem crs = this.envelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs)) {
            return "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
        }
        try {
            return "urn:ogc:def:crs:EPSG::" + CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Failed to lookup EPSG code for " + crs, e);
            return null;
        }
    }

    public String toString() {
        return "BoundsAndCRS{envelope=" + this.envelope + "}";
    }
}

