/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.geowebcache.grid.GridSubset;

class TileIterator
implements Iterator<long[]> {
    private long minY;
    private final int zoomEnd;
    private List<GridSubset> subsets;
    private long x;
    private long y;
    private int z;
    private long[] resultPosition = new long[3];
    private long[] tmpPosition = new long[3];
    private List<GridSubset> rowSubsets = new ArrayList<GridSubset>();
    private long rowMaxX;

    TileIterator(List<GridSubset> subsets, int zoomStart, int zoomEnd) {
        this.zoomEnd = zoomEnd;
        if (subsets.isEmpty()) {
            this.z = zoomEnd + 1;
        } else {
            this.subsets = subsets;
            this.z = zoomStart;
            this.minY = subsets.stream().map(ss -> ss.getCoverage(this.z)[1]).min((l1, l2) -> Long.compare(l1, l2)).get();
            this.y = this.minY - 1L;
            this.nextRow();
        }
    }

    private boolean nextRow() {
        ++this.y;
        this.rowSubsets = this.getRowSubsets(this.y);
        if (this.rowSubsets.isEmpty()) {
            Optional<Long> nextY = this.subsets.stream().filter(ss -> {
                long[] coverage = ss.getCoverage(this.z);
                return coverage[1] > this.y;
            }).map(ss -> ss.getCoverage(this.z)[1]).min((l1, l2) -> Long.compare(l1, l2));
            if (nextY.isPresent()) {
                this.y = nextY.get();
                this.rowSubsets = this.getRowSubsets(this.y);
            } else {
                return false;
            }
        }
        this.x = this.rowSubsets.stream().map(ss -> ss.getCoverage(this.z)[0]).min((l1, l2) -> Long.compare(l1, l2)).get();
        this.rowMaxX = this.rowSubsets.stream().map(ss -> ss.getCoverage(this.z)[2]).max((l1, l2) -> Long.compare(l1, l2)).get();
        return true;
    }

    private List<GridSubset> getRowSubsets(long y) {
        return this.subsets.stream().filter(ss -> {
            long[] coverage = ss.getCoverage(this.z);
            return this.y >= coverage[1] && y <= coverage[3];
        }).sorted((ss1, ss2) -> Long.signum(ss1.getCoverage(this.z)[0] - ss2.getCoverage(this.z)[0])).collect(Collectors.toList());
    }

    private boolean nextColumn() {
        while (this.x <= this.rowMaxX && !this.rowSubsets.isEmpty()) {
            this.tmpPosition[0] = ++this.x;
            this.tmpPosition[1] = this.y;
            this.tmpPosition[2] = this.z;
            if (this.rowSubsets.get(0).covers(this.tmpPosition)) {
                return true;
            }
            while (!this.rowSubsets.isEmpty()) {
                this.rowSubsets.remove(0);
                if (this.rowSubsets.isEmpty()) continue;
                if (this.rowSubsets.get(0).covers(this.tmpPosition)) {
                    return true;
                }
                long temp = this.rowSubsets.get(0).getCoverage(this.z)[0];
                if (temp <= this.x) continue;
                this.x = temp;
                return true;
            }
        }
        return !this.rowSubsets.isEmpty() && this.x <= this.rowMaxX;
    }

    @Override
    public boolean hasNext() {
        return this.z <= this.zoomEnd;
    }

    @Override
    public long[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.resultPosition[0] = this.x;
        this.resultPosition[1] = this.y;
        this.resultPosition[2] = this.z;
        if (this.z <= this.zoomEnd && !this.nextColumn() && !this.nextRow()) {
            ++this.z;
            if (this.z <= this.zoomEnd) {
                this.y = this.minY - 1L;
                this.nextRow();
            }
        }
        return this.resultPosition;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "," + this.z + "]. Over " + this.subsets;
    }
}

