/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONArray;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.coverages.CoveragesResponse;
import org.geoserver.ogcapi.v1.coverages.CoveragesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.WCSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CollectionsTest
extends CoveragesTestSupport {
    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1/collections", 200);
        this.testCollectionsJson(json);
    }

    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageInfo c = this.getCatalog().getCoverageByName("rs", "BlueMarble");
        int expected = this.getCatalog().getCoverages().size();
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1/collections", 200);
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        c.setLatLonBoundingBox(null);
        this.getCatalog().save((ResourceInfo)c);
        DocumentContext json2 = this.getAsJSONPath("ogc/coverages/v1/collections", 200);
        Assert.assertEquals((long)(expected - 1), (long)((Integer)json2.read("collections.length()", Integer.class, new Predicate[0])).intValue());
    }

    @Before
    public void revertChanges() throws IOException {
        CoverageInfo c = this.getCatalog().getCoverageByName("rs", "BlueMarble");
        ReferencedEnvelope blueMarbleExtent = new ReferencedEnvelope(146.49999999999477, 147.99999999999474, -44.49999999999785, -42.99999999999787, c.getCRS());
        c.setLatLonBoundingBox(blueMarbleExtent);
        this.getCatalog().save((ResourceInfo)c);
    }

    private void testCollectionsJson(DocumentContext json) throws Exception {
        int expected = this.getCatalog().getCoverages().size();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)applicationContext)).getProducibleMediaTypes(CoveragesResponse.class, false);
        MatcherAssert.assertThat((Object)formats.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)json.read("collections[0].links.length()", Integer.class, new Predicate[0]))));
        for (Object format : formats) {
            List items = (List)json.read("collections[0].links[?(@.type=='" + (MediaType)format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)"http://www.opengis.net/def/rel/ogc/1.0/coverage", item.get("rel"));
        }
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5000)));
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/IAU/0/1000"}));
        crs.remove("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        for (String c : crs) {
            Assert.assertTrue((String)(c + " is not using the expect CRS URI format"), (boolean)c.matches("http://www.opengis.net/def/crs/[\\w]+/\\d+/\\d+"));
        }
        MatcherAssert.assertThat((Object)((Iterable)json.read("collections[?(@.id=='rs:BlueMarble')].crs", new Predicate[0])), (Matcher)Matchers.contains((Object[])new List[]{Arrays.asList("http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326")}));
        List rsDemCRSList = (List)json.read("collections[?(@.id=='rs:DEM')].crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)rsDemCRSList, (Matcher)Matchers.contains((Object[])new Object[]{Arrays.asList("http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/3003")}));
    }

    @Test
    public void testCollectionsWorkspaceSpecificJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("rs/ogc/coverages/v1/collections", 200);
        long expected = this.getCatalog().getCoverages().stream().filter(ci -> "rs".equals(ci.getStore().getWorkspace().getName())).count();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='BlueMarble')]", new Predicate[0])), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='rs:BlueMarble')]", new Predicate[0])), (Matcher)Matchers.empty());
        String bmHrefPath = "collections[?(@.id=='BlueMarble')].links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/coverage' && @.type=='image/geotiff')].href";
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rs/ogc/coverages/v1/collections/BlueMarble/coverage?f=image%2Fgeotiff", (Object)((JSONArray)json.read("collections[?(@.id=='BlueMarble')].links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/coverage' && @.type=='image/geotiff')].href", new Predicate[0])).get(0));
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/coverages/v1/collections/?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testCollectionsJson((DocumentContext)json);
    }

    @Test
    public void testCollectionsHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/coverages/v1/collections?f=html");
        List coverages = this.getCatalog().getCoverages();
        for (CoverageInfo coverage : coverages) {
            String encodedName = coverage.prefixedName().replace(":", "__");
            Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
            Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/coverages/v1/collections/" + coverage.prefixedName() + "/coverage?f=image%2Fgeotiff"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
        }
        CoverageInfo coverage = this.getCatalog().getCoverageByName("rs:DEM");
        String tazDemName = coverage.prefixedName();
        String tazDemHtmlId = tazDemName.replace(":", "__");
        Assert.assertEquals((Object)"Down under digital elevation model", (Object)document.select("#" + tazDemHtmlId + "_title").text());
        Assert.assertEquals((Object)"So that you know where up and down are", (Object)document.select("#" + tazDemHtmlId + "_description").text());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionsHTMLWithProxyBase() throws Exception {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo info = gs.getGlobal();
        SettingsInfo settings = info.getSettings();
        settings.setProxyBaseUrl("http://testHost/geoserver");
        gs.save(info);
        try {
            Document document = this.getAsJSoup("ogc/coverages/v1/collections?f=html");
            List coverages = this.getCatalog().getCoverages();
            for (CoverageInfo coverage : coverages) {
                String encodedName = coverage.prefixedName().replace(":", "__");
                Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
                Assert.assertEquals((Object)("http://testHost/geoserver/ogc/coverages/v1/collections/" + coverage.prefixedName() + "/coverage?f=image%2Fgeotiff"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
            }
        }
        finally {
            info = gs.getGlobal();
            settings = info.getSettings();
            settings.setProxyBaseUrl(null);
            gs.save(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionsHTMLWithProxyBaseHeader() throws Exception {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo info = gs.getGlobal();
        SettingsInfo settings = info.getSettings();
        settings.setProxyBaseUrl("${X-Forwarded-Proto}://test-headers/geoserver/");
        info.getSettings().setUseHeadersProxyURL(Boolean.valueOf(true));
        gs.save(info);
        try {
            MockHttpServletRequest request = this.createRequest("ogc/coverages/v1/collections?f=html");
            request.setMethod("GET");
            request.setContent(new byte[0]);
            request.addHeader("X-Forwarded-Proto", (Object)"http");
            MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
            LOGGER.log(Level.INFO, "Last request returned\n:" + response.getContentAsString());
            Document document = Jsoup.parse((String)response.getContentAsString());
            List coverages = this.getCatalog().getCoverages();
            for (CoverageInfo coverage : coverages) {
                String encodedName = coverage.prefixedName().replace(":", "__");
                Assert.assertNotNull((Object)document.select("#html_" + encodedName + "_link"));
                Assert.assertEquals((Object)("http://test-headers/geoserver/ogc/coverages/v1/collections/" + coverage.prefixedName() + "/coverage?f=image%2Fgeotiff"), (Object)document.select("#html_" + encodedName + "_link").attr("href"));
            }
        }
        finally {
            info = gs.getGlobal();
            settings = info.getSettings();
            settings.setProxyBaseUrl(null);
            info.getSettings().setUseHeadersProxyURL(null);
            gs.save(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomCRSList() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        List srs = wcs.getSRS();
        srs.add("3857");
        srs.add("32632");
        try {
            gs.save((ServiceInfo)wcs);
            DocumentContext json = this.getAsJSONPath("cdf/ogc/coverages/v1/collections", 200);
            List crs = (List)json.read("crs", new Predicate[0]);
            MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.contains((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32632"}));
        }
        finally {
            wcs.getSRS().clear();
            gs.save((ServiceInfo)wcs);
        }
    }
}

