/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.ogcapi.v1.coverages.CoveragesTestSupport;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class CoverageTest
extends CoveragesTestSupport {
    private static final double EPS = 1.0E-6;

    @Test
    public void testGetFullCoverage() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage");
        this.assertBBOXDEM(response, 120, 240, 145.0, 146.0, -43.0, -41.0);
    }

    @Test
    public void testGetBBOX() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage?bbox=145.5,-42,146,-41.5");
        this.assertBBOXDEM(response, 60, 60, 145.5, 146.0, -42.0, -41.5);
    }

    @Test
    public void testSpatialSubsetRange() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage?subset=Long(145.5:146),Lat(-42:-41.5)");
        this.assertBBOXDEM(response, 60, 60, 145.5, 146.0, -42.0, -41.5);
    }

    @Test
    public void testSpatialSubsetSlice() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage?subset=Long(145.5),Lat(-41.5)");
        this.assertBBOXDEM(response, 1, 1, 145.5, 145.508333, -41.508333, -41.5);
    }

    @Test
    public void testSpatialSubsetWrongAxis() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage?subset=CutIt(145.5)");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        DocumentContext error = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"Invalid axis label provided: CutIt", (Object)error.read("title", new Predicate[0]));
    }

    @Test
    public void testDatetime() throws Exception {
        String[] suffixes;
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        double[] values = new double[]{20.53, 14.77, 14.6, 20.66, 20.53, 14.77};
        for (String suffix : suffixes = new String[]{"", "-01", "-01-01", "-01-01T00:00:00Z", "-01-01T00:00:00.000Z"}) {
            for (int i = 0; i < 6; ++i) {
                String date = 2014 + i + suffix;
                MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/sf:timeseries/coverage?datetime=" + date);
                Assert.assertEquals((long)200L, (long)response.getStatus());
                Assert.assertEquals((Object)"image/tiff;application=geotiff", (Object)response.getContentType());
                GridCoverage2D targetCoverage = this.getCoverage(response);
                double[] pixel = new double[1];
                targetCoverage.evaluate((Point2D)new Point2D.Double(14.32, 40.66), pixel);
                Assert.assertEquals((double)values[i], (double)pixel[0], (double)0.01);
                targetCoverage.dispose(true);
            }
        }
    }

    @Test
    public void testVersionHeader() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/coverages/v1/collections/rs:DEM/coverage");
        Assert.assertTrue((boolean)this.headerHasValue(response, "API-Version", "1.0.0"));
    }

    private void assertBBOXDEM(MockHttpServletResponse response, int width, int height, double xMin, double xMax, double yMin, double yMax) throws IOException, FactoryException {
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/tiff;application=geotiff", (Object)response.getContentType());
        GridCoverage2D targetCoverage = this.getCoverage(response);
        GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
        Assert.assertEquals((long)width, (long)gridRange.getSpan(0));
        Assert.assertEquals((long)height, (long)gridRange.getSpan(1));
        Assert.assertEquals((double)xMin, (double)targetCoverage.getEnvelope().getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)xMax, (double)targetCoverage.getEnvelope().getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)yMin, (double)targetCoverage.getEnvelope().getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)yMax, (double)targetCoverage.getEnvelope().getMaximum(1), (double)1.0E-6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D getCoverage(MockHttpServletResponse response) throws IOException {
        byte[] binary = this.getBinary(response);
        File file = File.createTempFile("temp", ".tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])binary);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        try {
            ParameterValue deferredLoad = GeoTiffFormat.USE_JAI_IMAGEREAD.createValue();
            deferredLoad.setValue(false);
            GridCoverage2D gridCoverage2D = reader.read(new GeneralParameterValue[]{deferredLoad});
            return gridCoverage2D;
        }
        finally {
            try {
                reader.dispose();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to dispose of the reader, unexpected but not necessarily serious", e);
            }
            file.delete();
        }
    }
}

