/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.ogcapi.v1.coverages.CoveragesTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class DomainSetTest
extends CoveragesTestSupport {
    private static final double EPS = 1.0E-6;

    @Test
    public void testDemDomainSet() throws Exception {
        DocumentContext domain = this.getAsJSONPath("ogc/coverages/v1/collections/rs:DEM/coverage/domainset", 200);
        Assert.assertEquals((Object)"DomainSetType", (Object)domain.read("type", new Predicate[0]));
        DocumentContext generalGrid = this.readContext(domain, "generalGrid");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)generalGrid.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("Long", "Lat"), (Object)generalGrid.read("axisLabels", new Predicate[0]));
        DocumentContext longAxis = this.readContext(generalGrid, "axis[0]");
        Assert.assertEquals((Object)"RegularAxisType", (Object)longAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"Long", (Object)longAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((double)145.0, (double)((Double)longAxis.read("lowerBound", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)146.0, (double)((Double)longAxis.read("upperBound", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)0.008333334, (double)((Double)longAxis.read("resolution", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((Object)"deg", (Object)longAxis.read("uomLabel", new Predicate[0]));
        DocumentContext latAxis = this.readContext(generalGrid, "axis[1]");
        Assert.assertEquals((Object)"RegularAxisType", (Object)latAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"Lat", (Object)latAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((double)-43.0, (double)((Double)latAxis.read("lowerBound", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)-41.0, (double)((Double)latAxis.read("upperBound", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)0.008333334, (double)((Double)latAxis.read("resolution", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((Object)"deg", (Object)latAxis.read("uomLabel", new Predicate[0]));
        DocumentContext gridLimits = this.readContext(generalGrid, "gridLimits");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/0/Index2D", (Object)gridLimits.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("i", "j"), (Object)gridLimits.read("axisLabels", new Predicate[0]));
        DocumentContext iAxis = this.readContext(gridLimits, "axis[0]");
        Assert.assertEquals((Object)"IndexAxisType", (Object)iAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"i", (Object)iAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)iAxis.read("lowerBound", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)119L, (long)((Integer)iAxis.read("upperBound", Integer.class, new Predicate[0])).intValue());
        DocumentContext jAxis = this.readContext(gridLimits, "axis[1]");
        Assert.assertEquals((Object)"IndexAxisType", (Object)jAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"j", (Object)jAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)jAxis.read("lowerBound", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)239L, (long)((Integer)jAxis.read("upperBound", Integer.class, new Predicate[0])).intValue());
    }

    @Test
    public void testTimeListPresentation() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        DocumentContext domain = this.getAsJSONPath("ogc/coverages/v1/collections/sf:timeseries/coverage/domainset", 200);
        Assert.assertEquals((Object)"DomainSetType", (Object)domain.read("type", new Predicate[0]));
        DocumentContext generalGrid = this.readContext(domain, "generalGrid");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)generalGrid.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("Long", "Lat", "Time"), (Object)generalGrid.read("axisLabels", new Predicate[0]));
        DocumentContext timeAxis = this.readContext(generalGrid, "axis[2]");
        Assert.assertEquals((Object)"IrregularAxisType", (Object)timeAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"Time", (Object)timeAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((Object)"s", (Object)timeAxis.read("uomLabel", new Predicate[0]));
        List expectedTimes = IntStream.range(2014, 2020).mapToObj(y -> y + "-01-01T00:00:00.000Z").collect(Collectors.toList());
        Assert.assertEquals(expectedTimes, (Object)timeAxis.read("coordinate", new Predicate[0]));
        DocumentContext gridLimits = this.readContext(generalGrid, "gridLimits");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/0/Index3D", (Object)gridLimits.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("i", "j", "k"), (Object)gridLimits.read("axisLabels", new Predicate[0]));
        DocumentContext kAxis = this.readContext(gridLimits, "axis[2]");
        Assert.assertEquals((Object)"IndexAxisType", (Object)kAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"k", (Object)kAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)kAxis.read("lowerBound", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)kAxis.read("upperBound", Integer.class, new Predicate[0])).intValue());
    }

    @Test
    public void testTimeIntervalPresentation() throws Exception {
        double oneYear = 3.1536E10;
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.DISCRETE_INTERVAL, oneYear, null, "s");
        DocumentContext domain = this.getAsJSONPath("ogc/coverages/v1/collections/sf:timeseries/coverage/domainset", 200);
        Assert.assertEquals((Object)"DomainSetType", (Object)domain.read("type", new Predicate[0]));
        DocumentContext generalGrid = this.readContext(domain, "generalGrid");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)generalGrid.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("Long", "Lat", "Time"), (Object)generalGrid.read("axisLabels", new Predicate[0]));
        DocumentContext timeAxis = this.readContext(generalGrid, "axis[2]");
        Assert.assertEquals((Object)"RegularAxisType", (Object)timeAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"Time", (Object)timeAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((Object)"y", (Object)timeAxis.read("uomLabel", new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)timeAxis.read("resolution", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"2014-01-01T00:00:00.000Z", (Object)timeAxis.read("lowerBound", new Predicate[0]));
        Assert.assertEquals((Object)"2019-01-01T00:00:00.000Z", (Object)timeAxis.read("upperBound", new Predicate[0]));
        DocumentContext gridLimits = this.readContext(generalGrid, "gridLimits");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/0/Index3D", (Object)gridLimits.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("i", "j", "k"), (Object)gridLimits.read("axisLabels", new Predicate[0]));
        DocumentContext kAxis = this.readContext(gridLimits, "axis[2]");
        Assert.assertEquals((Object)"IndexAxisType", (Object)kAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"k", (Object)kAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)kAxis.read("lowerBound", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)kAxis.read("upperBound", Integer.class, new Predicate[0])).intValue());
    }

    @Test
    public void testTimeContinuousIntervalPresentation() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, "s");
        DocumentContext domain = this.getAsJSONPath("ogc/coverages/v1/collections/sf:timeseries/coverage/domainset", 200);
        Assert.assertEquals((Object)"DomainSetType", (Object)domain.read("type", new Predicate[0]));
        DocumentContext generalGrid = this.readContext(domain, "generalGrid");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)generalGrid.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("Long", "Lat", "Time"), (Object)generalGrid.read("axisLabels", new Predicate[0]));
        DocumentContext timeAxis = this.readContext(generalGrid, "axis[2]");
        Assert.assertEquals((Object)"RegularAxisType", (Object)timeAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"Time", (Object)timeAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((Object)"s", (Object)timeAxis.read("uomLabel", new Predicate[0]));
        Assert.assertEquals((Object)"2014-01-01T00:00:00.000Z", (Object)timeAxis.read("lowerBound", new Predicate[0]));
        Assert.assertEquals((Object)"2019-01-01T00:00:00.000Z", (Object)timeAxis.read("upperBound", new Predicate[0]));
        DocumentContext gridLimits = this.readContext(generalGrid, "gridLimits");
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/0/Index3D", (Object)gridLimits.read("srsName", new Predicate[0]));
        Assert.assertEquals(Arrays.asList("i", "j", "k"), (Object)gridLimits.read("axisLabels", new Predicate[0]));
        DocumentContext kAxis = this.readContext(gridLimits, "axis[2]");
        Assert.assertEquals((Object)"IndexAxisType", (Object)kAxis.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"k", (Object)kAxis.read("axisLabel", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)kAxis.read("lowerBound", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)157766400L, (long)((Integer)kAxis.read("upperBound", Integer.class, new Predicate[0])).intValue());
    }
}

