/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.v1.coverages.CoveragesService;
import org.geoserver.ogcapi.v1.coverages.CoveragesTestSupport;
import org.geoserver.platform.Service;
import org.geoserver.wcs.WCSInfo;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class LandingPageTest
extends CoveragesTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Coverages", new Version("1.0.0"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Coverages", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.0"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(CoveragesService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getLandingPage", "getCollections", "describeCollection", "getConformanceDeclaration", "getCoverage", "getApi", "getCoverageDomainSet"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1/", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageWorkspaceSpecific() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/coverages/v1?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/yaml' && @.href =~ /.*ogc\\/coverages\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/yaml' && @.href =~ /.*ogc\\/coverages\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/coverages/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/coverages/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/coverages/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/coverages/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    @Test
    public void testLandingPageHTMLInWorkspace() throws Exception {
        Document document = this.getAsJSoup("sf/ogc/coverages/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/coverages/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/coverages/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)12L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/coverages\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/coverages\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/coverages\\/v1\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/coverages/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0", (Object)this.readSingle(json, "links[?(@.type=='application/vnd.oai.openapi+json;version=3.0')].href"));
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/coverages\\/v1\\/conformance.*/)].rel", new String[]{"conformance", "conformance", "conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/coverages\\/v1\\/collections.*/)].rel", new String[]{"data", "data", "data"});
        Assert.assertEquals((Object)"Coverages 1.0 server", (Object)json.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"", (Object)json.read("description", new Predicate[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledService() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo service = (WCSInfo)gs.getService(WCSInfo.class);
        service.setEnabled(false);
        gs.save((ServiceInfo)service);
        try {
            MockHttpServletResponse httpServletResponse = this.getAsMockHttpServletResponse("ogc/coverages/v1", 404);
            Assert.assertEquals((Object)"Service Coverages is disabled", (Object)httpServletResponse.getErrorMessage());
        }
        finally {
            service.setEnabled(true);
            gs.save((ServiceInfo)service);
        }
    }
}

