/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.ogcapi.v1.coverages.CoveragesResponse;
import org.geoserver.ogcapi.v1.coverages.cis.DomainSet;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links"})
public class CollectionDocument
extends AbstractCollectionDocument<CoverageInfo> {
    static final Logger LOGGER = Logging.getLogger(CollectionDocument.class);
    public static final String REL_COVERAGE = "http://www.opengis.net/def/rel/ogc/1.0/coverage";
    public static final String REL_DOMAINSET = "http://www.opengis.net/def/rel/ogc/1.0/coverage-domainset";
    CoverageInfo coverage;
    String mapPreviewURL;
    List<String> crs;

    public CollectionDocument(GeoServer geoServer, CoverageInfo coverage, List<String> crs) throws IOException {
        super((Object)coverage);
        String apiUrl;
        String collectionId;
        this.id = collectionId = coverage.prefixedName();
        this.title = coverage.getTitle();
        this.description = coverage.getAbstract();
        ReferencedEnvelope bbox = coverage.getLatLonBoundingBox();
        if (bbox == null) {
            throw new RuntimeException("Coverage has no bounding box: " + coverage.getName());
        }
        DateRange timeExtent = TimeExtentCalculator.getTimeExtent((ResourceInfo)coverage);
        this.setExtent(new CollectionExtents(bbox, timeExtent));
        this.coverage = coverage;
        this.crs = crs;
        this.addSelfLinks("ogc/coverages/v1/collections/" + this.id);
        String baseUrl = APIRequestInfo.get().getBaseURL();
        for (MediaType format : APIRequestInfo.get().getProducibleMediaTypes(CoveragesResponse.class, false)) {
            apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/coverages/v1/collections/" + collectionId + "/coverage"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(apiUrl, REL_COVERAGE, format.toString(), collectionId + " coverage as " + format, "coverage"));
        }
        for (MediaType format : APIRequestInfo.get().getProducibleMediaTypes(DomainSet.class, false)) {
            apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/coverages/v1/collections/" + collectionId + "/coverage/domainset"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(apiUrl, REL_DOMAINSET, format.toString(), collectionId + " coverage domainset as " + format, "domainset"));
        }
        if (this.isWMSAvailable(geoServer)) {
            HashMap<String, String> kvp = new HashMap<String, String>();
            kvp.put("LAYERS", coverage.prefixedName());
            kvp.put("FORMAT", "application/openlayers");
            this.mapPreviewURL = ResponseUtils.buildURL((String)baseUrl, (String)"wms/reflect", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
    }

    private boolean isWMSAvailable(GeoServer geoServer) {
        ServiceInfo si = geoServer.getServices().stream().filter(s -> "WMS".equals(s.getId())).findFirst().orElse(null);
        return si != null;
    }

    @JsonIgnore
    public String getMapPreviewURL() {
        return this.mapPreviewURL;
    }

    public List<String> getCrs() {
        return this.crs;
    }
}

