/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import java.io.IOException;
import java.util.function.Predicate;
import net.opengis.wcs20.GetCoverageType;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.MessageConverterResponseAdapter;
import org.geoserver.ogcapi.v1.coverages.CoveragesResponse;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wcs2_0.response.WCS20GetCoverageResponse;
import org.geotools.api.coverage.grid.GridCoverage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class CoverageResponseMessageConverter
extends MessageConverterResponseAdapter<CoveragesResponse> {
    public CoverageResponseMessageConverter() {
        super(CoveragesResponse.class, GridCoverage.class);
    }

    protected void writeResponse(CoveragesResponse value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        block2: {
            try {
                this.setHeaders(value.getResponse(), operation, response, httpOutputMessage);
                response.write((Object)value.getResponse(), httpOutputMessage.getBody(), operation);
            }
            catch (RuntimeException e) {
                if (!e.getMessage().contains("Unable to render RenderedOp for this operation")) break block2;
                throw new APIException("NoApplicableCode", "Cannot encode this coverage in the requested format", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
    }

    protected void setHeaders(Object result, Operation operation, Response response, HttpOutputMessage message) {
    }

    protected Operation getOperation(CoveragesResponse result, Request dr, MediaType mediaType) {
        Operation op = dr.getOperation();
        GetCoverageType request = (GetCoverageType)result.getRequest();
        request.setFormat(mediaType.toString());
        return new Operation("GetCoverage", op.getService(), op.getMethod(), new Object[]{request});
    }

    protected Predicate<Response> getResponseFilterPredicate() {
        return r -> r instanceof WCS20GetCoverageResponse;
    }
}

