/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.ogcapi.v1.dggs.DGGSInfo;
import org.geoserver.ogcapi.v1.dggs.DGGSService;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class LandingPageTest
extends OGCApiTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("DGGS", new Version("1.0.1"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"DGGS", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.1"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(DGGSService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getApi", "getCollections", "getConformanceDeclaration", "getLandingPage", "polygon", "point", "getZones", "getZone", "describeCollection", "getChildren", "getNeighbors", "getParents", "dapaDescription", "dapaVariables", "dapaAreaRetrieve", "dapaAreaSpaceTimeAggregate", "dapaAreaSpaceAggregate", "dapaAreaTimeAggregate", "dapaPositionRetrieve", "dapaPositionTimeAggregate"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1/", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageWorkspaceSpecific() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    @Ignore
    public void testLandingPageXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/dggs/v1?f=application/xml");
        this.print(dom);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/dggs/v1?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/yaml' && @.href =~ /.*ogc\\/dggs\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/yaml' && @.href =~ /.*ogc\\/dggs\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/dggs/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    @Test
    public void testLandingPageHTMLInWorkspace() throws Exception {
        Document document = this.getAsJSoup("sf/ogc/dggs/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/dggs/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/dggs/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/dggs/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)12L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/dggs\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/dggs\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/dggs\\/v1\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0", (Object)this.readSingle(json, "links[?(@.type=='application/vnd.oai.openapi+json;version=3.0')].href"));
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/dggs\\/v1\\/conformance.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/dggs\\/v1\\/collections.*/)].rel", new String[]{"data", "data", "data"});
        Assert.assertEquals((Object)"Discrete Global Grid Systems Service", (Object)json.read("title", new Predicate[0]));
        Assert.assertTrue((boolean)((String)json.read("description", new Predicate[0])).contains("OGCAPI-DGGS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledService() throws Exception {
        GeoServer gs = this.getGeoServer();
        DGGSInfo service = (DGGSInfo)gs.getService(DGGSInfo.class);
        service.setEnabled(false);
        gs.save((ServiceInfo)service);
        try {
            MockHttpServletResponse httpServletResponse = this.getAsMockHttpServletResponse("ogc/dggs/v1", 404);
            Assert.assertEquals((Object)"Service DGGS is disabled", (Object)httpServletResponse.getErrorMessage());
        }
        finally {
            service.setEnabled(true);
            gs.save((ServiceInfo)service);
        }
    }
}

