/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.ogcapi.APIException;
import org.geotools.feature.visitor.Aggregate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AggregateConverter
implements Converter<String, Aggregate[]> {
    private static final Map<String, Aggregate> AGGREGATES = new HashMap<String, Aggregate>();

    public static Map<String, Aggregate> getAggregates() {
        return Collections.unmodifiableMap(AGGREGATES);
    }

    public Aggregate[] convert(String s) {
        return (Aggregate[])Arrays.stream(s.split("\\s*,\\s*")).map(n -> this.mapAggregate((String)n)).toArray(Aggregate[]::new);
    }

    private Aggregate mapAggregate(String name) {
        Aggregate agg = AGGREGATES.get(name);
        if (agg == null) {
            throw new APIException("InvalidParameterValue", "Un-recognized aggregate : " + name, HttpStatus.BAD_REQUEST);
        }
        return agg;
    }

    static {
        Arrays.stream(Aggregate.values()).forEach(a -> {
            if (a == Aggregate.STD_DEV) {
                AGGREGATES.put("std-dev", (Aggregate)a);
            } else if (a == Aggregate.AVERAGE) {
                AGGREGATES.put("mean", (Aggregate)a);
            } else if (a != Aggregate.SUMAREA && a != Aggregate.MEDIAN) {
                AGGREGATES.put(a.name().toLowerCase(), (Aggregate)a);
            }
        });
    }
}

