/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.sf.json.util.JSONBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.TemporalUtils;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.dggs.CollectionDocument;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.NameImpl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class DGGSJSONMessageConverter
implements HttpMessageConverter<FeaturesResponse> {
    public static final String DGGS_JSON_MIME = "application/dggs+json";
    public static MediaType DGGS_JSON_TYPE = MediaType.parseMediaType((String)"application/dggs+json");
    private final GeoServer gs;

    public DGGSJSONMessageConverter(GeoServer gs) {
        this.gs = gs;
    }

    public boolean canRead(Class<?> aClass, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> aClass, MediaType mediaType) {
        if (!FeaturesResponse.class.isAssignableFrom(aClass)) {
            return false;
        }
        if (mediaType != null && !DGGS_JSON_TYPE.isCompatibleWith(mediaType)) {
            return false;
        }
        Request request = (Request)Dispatcher.REQUEST.get();
        return request != null && "DGGS".equals(request.getService());
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(DGGS_JSON_TYPE);
    }

    public FeaturesResponse read(Class<? extends FeaturesResponse> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedEncodingException();
    }

    public void write(FeaturesResponse featureResponse, MediaType mediaType, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        try (Writer writer = DGGSJSONMessageConverter.getWriter(httpOutputMessage);){
            JSONBuilder jsonWriter = new JSONBuilder(writer);
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            jsonWriter.key("features");
            jsonWriter.array();
            FeatureCollectionResponse response = featureResponse.getResponse();
            GetFeatureRequest request = GetFeatureRequest.adapt((Object)featureResponse.getRequest());
            SimpleFeatureCollection fc = (SimpleFeatureCollection)response.getFeature().get(0);
            this.writeCollection(fc, jsonWriter);
            jsonWriter.endArray();
            BigInteger totalNumberOfFeatures = Optional.ofNullable(response.getTotalNumberOfFeatures()).filter(n -> n.signum() >= 0).orElse(null);
            BigInteger featureCount = Optional.ofNullable(response.getNumberOfFeatures()).filter(n -> n.signum() >= 0).orElse(null);
            this.writeCollectionCounts(totalNumberOfFeatures, featureCount, jsonWriter);
            this.writeCollectionTimeStamp(jsonWriter);
            this.writeLinks(response, request, jsonWriter, null);
            jsonWriter.endObject();
            writer.flush();
        }
    }

    private void writeCollection(SimpleFeatureCollection fc, JSONBuilder jsonWriter) {
        SimpleFeatureType fType = (SimpleFeatureType)fc.getSchema();
        List types = fType.getAttributeDescriptors();
        try (SimpleFeatureIterator iterator = fc.features();){
            while (iterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
                jsonWriter.object();
                jsonWriter.key("type").value((Object)"Feature");
                jsonWriter.key("geometry").object();
                jsonWriter.key("type").value((Object)"polygon");
                jsonWriter.key("identifiers");
                jsonWriter.array();
                jsonWriter.value(simpleFeature.getAttribute("zoneId"));
                jsonWriter.endArray();
                jsonWriter.endObject();
                jsonWriter.key("properties");
                jsonWriter.object();
                for (int j = 0; j < types.size(); ++j) {
                    Object value = simpleFeature.getAttribute(j);
                    AttributeDescriptor ad = (AttributeDescriptor)types.get(j);
                    String attributeName = ad.getLocalName();
                    if ("zoneId".equals(attributeName) || ad instanceof GeometryDescriptor) continue;
                    if (Date.class.isAssignableFrom(ad.getType().getBinding()) && TemporalUtils.isDateTimeFormatEnabled()) {
                        jsonWriter.key(attributeName);
                        jsonWriter.value((Object)TemporalUtils.printDate((Date)((Date)value)));
                        continue;
                    }
                    jsonWriter.key(attributeName);
                    if (value instanceof Double && Double.isNaN((Double)value) || value instanceof Float && Float.isNaN(((Float)value).floatValue())) {
                        jsonWriter.value(null);
                        continue;
                    }
                    if (value instanceof Double && (Double)value == Double.POSITIVE_INFINITY || value instanceof Float && ((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                        jsonWriter.value((Object)"Infinity");
                        continue;
                    }
                    if (value instanceof Double && (Double)value == Double.NEGATIVE_INFINITY || value instanceof Float && ((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                        jsonWriter.value((Object)"-Infinity");
                        continue;
                    }
                    jsonWriter.value(value);
                }
                jsonWriter.endObject();
                jsonWriter.endObject();
            }
        }
    }

    protected void writeCollectionCounts(BigInteger featureCount, BigInteger numberReturned, JSONBuilder jsonWriter) {
        if (featureCount != null) {
            jsonWriter.key("numberMatched").value((Object)featureCount);
        }
        jsonWriter.key("numberReturned").value((Object)numberReturned);
    }

    private static Writer getWriter(HttpOutputMessage outputMessage) throws IOException {
        return new OutputStreamWriter(outputMessage.getBody(), DGGSJSONMessageConverter.getCharset(outputMessage.getHeaders()));
    }

    private static Charset getCharset(HttpHeaders headers) {
        return Optional.ofNullable(headers).map(h -> headers.getContentType()).map(ct -> ct.getCharset()).orElse(StandardCharsets.UTF_8);
    }

    protected void writeCollectionTimeStamp(JSONBuilder jw) {
        jw.key("timeStamp").value((Object)new ISO8601Formatter().format(new Date()));
    }

    private void writeLinks(FeatureCollectionResponse response, GetFeatureRequest request, JSONBuilder jw, String featureId) {
        Object linkTitle;
        String linkType;
        String href;
        APIRequestInfo requestInfo = APIRequestInfo.get();
        FeatureTypeInfo featureType = this.getFeatureType(request);
        String baseUrl = request.getBaseUrl();
        jw.key("links");
        jw.array();
        if (response != null) {
            if (response.getPrevious() != null) {
                this.writeLink(jw, "Previous page", DGGS_JSON_MIME, "prev", response.getPrevious());
            }
            if (response.getNext() != null) {
                this.writeLink(jw, "Next page", DGGS_JSON_MIME, "next", response.getNext());
            }
        }
        Collection formats = requestInfo.getProducibleMediaTypes(FeaturesResponse.class, true);
        for (MediaType format : formats) {
            Map kvp = APIRequestInfo.get().getSimpleQueryMap();
            kvp.put("f", format.toString());
            href = ResponseUtils.buildURL((String)baseUrl, (String)APIRequestInfo.get().getRequestPath(), (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            linkType = "alternate";
            linkTitle = "This document as " + format;
            if (format.toString().equals(DGGS_JSON_MIME)) {
                linkType = "self";
                linkTitle = "This document";
            }
            this.writeLink(jw, (String)linkTitle, format.toString(), linkType, href);
        }
        String basePath = "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)featureType.prefixedName(), (char[])new char[0]);
        for (MediaType format : requestInfo.getProducibleMediaTypes(CollectionDocument.class, true)) {
            href = ResponseUtils.buildURL((String)baseUrl, (String)basePath, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            linkType = "collection";
            linkTitle = "The collection description as " + format;
            this.writeLink(jw, (String)linkTitle, format.toString(), linkType, href);
        }
        jw.endArray();
    }

    protected void writeLink(JSONBuilder jw, String title, String mimeType, String rel, String href) {
        if (href != null) {
            jw.object();
            if (title != null) {
                jw.key("title").value((Object)title);
            }
            if (mimeType != null) {
                jw.key("type").value((Object)mimeType);
            }
            if (rel != null) {
                jw.key("rel").value((Object)rel);
            }
            jw.key("href").value((Object)href);
            jw.endObject();
        }
    }

    private FeatureTypeInfo getFeatureType(GetFeatureRequest request) {
        Query query = (Query)request.getQueries().get(0);
        QName typeName = (QName)query.getTypeNames().get(0);
        return this.gs.getCatalog().getFeatureTypeByName((Name)new NameImpl(typeName.getNamespaceURI(), typeName.getLocalPart()));
    }
}

