/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.ogcapi.v1.dggs.CollectionDAPA;
import org.geoserver.ogcapi.v1.dggs.DAPAVariables;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.gstore.DGGSStore;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "dggs-id", "resolutions", "links"})
public class CollectionDocument
extends AbstractCollectionDocument<FeatureTypeInfo> {
    static final Logger LOGGER = Logging.getLogger(CollectionDocument.class);
    private final DGGSFeatureSource fs;
    FeatureTypeInfo featureType;
    String mapPreviewURL;

    public CollectionDocument(GeoServer geoServer, FeatureTypeInfo featureType) throws IOException {
        super((Object)featureType);
        String collectionId;
        this.id = collectionId = featureType.prefixedName();
        this.title = featureType.getTitle();
        this.description = featureType.getAbstract();
        ReferencedEnvelope bbox = featureType.getLatLonBoundingBox();
        DateRange timeExtent = TimeExtentCalculator.getTimeExtent((ResourceInfo)featureType);
        this.setExtent(new CollectionExtents(bbox, timeExtent));
        this.featureType = featureType;
        String baseUrl = APIRequestInfo.get().getBaseURL();
        Collection zoneFormats = APIRequestInfo.get().getProducibleMediaTypes(FeaturesResponse.class, true);
        for (MediaType format : zoneFormats) {
            String apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/dggs/collections/" + collectionId + "/zones"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(apiUrl, "zones", format.toString(), collectionId + " items as " + format.toString(), "zones"));
        }
        DimensionInfo time = (DimensionInfo)featureType.getMetadata().get("time", DimensionInfo.class);
        if (time != null) {
            Collection dapaFormats = APIRequestInfo.get().getProducibleMediaTypes(CollectionDAPA.class, true);
            for (MediaType format : dapaFormats) {
                String dapaURL = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/dggs/collections/" + collectionId + "/processes"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.addLink(new Link(dapaURL, "ogc-dapa-processes", format.toString(), "DAPA for " + collectionId + " as " + format.toString(), "ogc-dapa-processes"));
            }
            Collection variablesFormats = APIRequestInfo.get().getProducibleMediaTypes(DAPAVariables.class, true);
            for (MediaType format : variablesFormats) {
                String variablesURL = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/dggs/collections/" + collectionId + "/variables"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.addLink(new Link(variablesURL, "ogc-dapa-variables", format.toString(), "DAPA variables for " + collectionId + " as " + format.toString(), "ogc-dapa-variables"));
            }
        }
        this.addSelfLinks("ogc/dggs/v1/collections/" + this.id);
        if (this.isWMSAvailable(geoServer)) {
            HashMap<String, String> kvp = new HashMap<String, String>();
            kvp.put("LAYERS", featureType.prefixedName());
            kvp.put("FORMAT", "application/openlayers");
            this.mapPreviewURL = ResponseUtils.buildURL((String)baseUrl, (String)"wms/reflect", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
        DGGSStore dggsStore = (DGGSStore)featureType.getStore().getDataStore(null);
        this.fs = dggsStore.getDGGSFeatureSource(featureType.getNativeName());
    }

    private boolean isWMSAvailable(GeoServer geoServer) {
        ServiceInfo si = geoServer.getServices().stream().filter(s -> "WMS".equals(s.getId())).findFirst().orElse(null);
        return si != null;
    }

    @JsonIgnore
    public FeatureType getSchema() {
        try {
            return this.featureType.getFeatureType();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to compute feature type", e);
            return null;
        }
    }

    @JsonIgnore
    public String getMapPreviewURL() {
        return this.mapPreviewURL;
    }

    public int[] getResolutions() throws IOException {
        UniqueVisitor visitor = new UniqueVisitor(new String[]{"resolution"});
        this.fs.getFeatures(Query.ALL).accepts((FeatureVisitor)visitor, null);
        List list = visitor.getResult().toList();
        int[] resolutions = list.stream().mapToInt(v -> v).toArray();
        return resolutions;
    }

    @JsonProperty(value="dggs-id")
    public String getDggsId() {
        return this.fs.getDGGS().getIdentifier();
    }
}

