/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.dggs.GroupedMatrixAggregate;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

class GroupMatrixFeatureCollection
implements SimpleFeatureCollection {
    private final SimpleFeatureType schema;
    private final GroupedMatrixAggregate.IterableResult result;
    private final Function<GroupedMatrixAggregate.GroupByResult, SimpleFeature> featureMapper;

    public GroupMatrixFeatureCollection(SimpleFeatureType schema, GroupedMatrixAggregate.IterableResult result, Function<GroupedMatrixAggregate.GroupByResult, SimpleFeature> featureMapper) {
        this.schema = schema;
        this.result = result;
        this.featureMapper = featureMapper;
    }

    public SimpleFeatureIterator features() {
        return new GroupMatrixFeatureIterator((CloseableIterator<GroupedMatrixAggregate.GroupByResult>)this.result.getIterator());
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public String getID() {
        return null;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SortedSimpleFeatureCollection((SimpleFeatureCollection)this, new SortBy[]{order});
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object o) {
        try (CloseableIterator it = this.result.getIterator();){
            do {
                if (!it.hasNext()) return false;
            } while (!Objects.equals(o, it.next()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsAll(Collection<?> o) {
        HashSet test = new HashSet(o);
        try (CloseableIterator it = this.result.getIterator();){
            while (it.hasNext() && !test.isEmpty()) {
                test.remove(it.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return test.isEmpty();
    }

    public boolean isEmpty() {
        boolean bl;
        block8: {
            CloseableIterator it = this.result.getIterator();
            try {
                bl = it.hasNext();
                if (it == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            it.close();
        }
        return bl;
    }

    public int size() {
        return DataUtilities.count((FeatureIterator)this.features());
    }

    public Object[] toArray() {
        return DataUtilities.list((FeatureCollection)this).toArray();
    }

    public <O> O[] toArray(O[] a) {
        return DataUtilities.list((FeatureCollection)this).toArray(a);
    }

    private class GroupMatrixFeatureIterator
    implements SimpleFeatureIterator {
        CloseableIterator<GroupedMatrixAggregate.GroupByResult> iterator;

        public GroupMatrixFeatureIterator(CloseableIterator<GroupedMatrixAggregate.GroupByResult> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            GroupedMatrixAggregate.GroupByResult result = (GroupedMatrixAggregate.GroupByResult)this.iterator.next();
            return GroupMatrixFeatureCollection.this.featureMapper.apply(result);
        }

        public void close() {
            try {
                this.iterator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

